package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{JobRunId, ApplicationId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDashboardForJobRunRequest(
    applicationId: ApplicationId,
    jobRunId: JobRunId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunRequest = {
    import GetDashboardForJobRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .jobRunId(JobRunId.unwrap(jobRunId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.GetDashboardForJobRunRequest.ReadOnly =
    zio.aws.emrserverless.model.GetDashboardForJobRunRequest
      .wrap(buildAwsValue())
}
object GetDashboardForJobRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.GetDashboardForJobRunRequest =
      zio.aws.emrserverless.model
        .GetDashboardForJobRunRequest(applicationId, jobRunId)
    def applicationId: ApplicationId
    def jobRunId: JobRunId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getJobRunId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(jobRunId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunRequest
  ) extends zio.aws.emrserverless.model.GetDashboardForJobRunRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val jobRunId: JobRunId =
      zio.aws.emrserverless.model.primitives.JobRunId(impl.jobRunId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunRequest
  ): zio.aws.emrserverless.model.GetDashboardForJobRunRequest.ReadOnly =
    new Wrapper(impl)
}
