package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{
  HiveCliParameters,
  InitScriptPath,
  Query
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Hive(
    query: Query,
    initQueryFile: Optional[InitScriptPath] = Optional.Absent,
    parameters: Optional[HiveCliParameters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.Hive = {
    import Hive.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.Hive
      .builder()
      .query(Query.unwrap(query): java.lang.String)
      .optionallyWith(
        initQueryFile.map(value =>
          InitScriptPath.unwrap(value): java.lang.String
        )
      )(_.initQueryFile)
      .optionallyWith(
        parameters.map(value =>
          HiveCliParameters.unwrap(value): java.lang.String
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.Hive.ReadOnly =
    zio.aws.emrserverless.model.Hive.wrap(buildAwsValue())
}
object Hive {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.Hive
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.Hive =
      zio.aws.emrserverless.model.Hive(
        query,
        initQueryFile.map(value => value),
        parameters.map(value => value)
      )
    def query: Query
    def initQueryFile: Optional[InitScriptPath]
    def parameters: Optional[HiveCliParameters]
    def getQuery: ZIO[Any, Nothing, Query] = ZIO.succeed(query)
    def getInitQueryFile: ZIO[Any, AwsError, InitScriptPath] =
      AwsError.unwrapOptionField("initQueryFile", initQueryFile)
    def getParameters: ZIO[Any, AwsError, HiveCliParameters] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.Hive
  ) extends zio.aws.emrserverless.model.Hive.ReadOnly {
    override val query: Query =
      zio.aws.emrserverless.model.primitives.Query(impl.query())
    override val initQueryFile: Optional[InitScriptPath] = zio.aws.core.internal
      .optionalFromNullable(impl.initQueryFile())
      .map(value =>
        zio.aws.emrserverless.model.primitives.InitScriptPath(value)
      )
    override val parameters: Optional[HiveCliParameters] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        zio.aws.emrserverless.model.primitives.HiveCliParameters(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.Hive
  ): zio.aws.emrserverless.model.Hive.ReadOnly = new Wrapper(impl)
}
