package zio.aws.emrserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emrserverless.model.primitives.{
  EngineType,
  Date,
  ApplicationName,
  ApplicationArn,
  ReleaseLabel,
  ApplicationId,
  String256
}
import scala.jdk.CollectionConverters._
final case class ApplicationSummary(
    id: ApplicationId,
    name: Optional[ApplicationName] = Optional.Absent,
    arn: ApplicationArn,
    releaseLabel: ReleaseLabel,
    `type`: EngineType,
    state: zio.aws.emrserverless.model.ApplicationState,
    stateDetails: Optional[String256] = Optional.Absent,
    createdAt: Date,
    updatedAt: Date,
    architecture: Optional[zio.aws.emrserverless.model.Architecture] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.ApplicationSummary
      .builder()
      .id(ApplicationId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .arn(ApplicationArn.unwrap(arn): java.lang.String)
      .releaseLabel(ReleaseLabel.unwrap(releaseLabel): java.lang.String)
      .`type`(EngineType.unwrap(`type`): java.lang.String)
      .state(state.unwrap)
      .optionallyWith(
        stateDetails.map(value => String256.unwrap(value): java.lang.String)
      )(_.stateDetails)
      .createdAt(Date.unwrap(createdAt): Instant)
      .updatedAt(Date.unwrap(updatedAt): Instant)
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.ApplicationSummary.ReadOnly =
    zio.aws.emrserverless.model.ApplicationSummary.wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.ApplicationSummary =
      zio.aws.emrserverless.model.ApplicationSummary(
        id,
        name.map(value => value),
        arn,
        releaseLabel,
        `type`,
        state,
        stateDetails.map(value => value),
        createdAt,
        updatedAt,
        architecture.map(value => value)
      )
    def id: ApplicationId
    def name: Optional[ApplicationName]
    def arn: ApplicationArn
    def releaseLabel: ReleaseLabel
    def `type`: EngineType
    def state: zio.aws.emrserverless.model.ApplicationState
    def stateDetails: Optional[String256]
    def createdAt: Date
    def updatedAt: Date
    def architecture: Optional[zio.aws.emrserverless.model.Architecture]
    def getId: ZIO[Any, Nothing, ApplicationId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, Nothing, ApplicationArn] = ZIO.succeed(arn)
    def getReleaseLabel: ZIO[Any, Nothing, ReleaseLabel] =
      ZIO.succeed(releaseLabel)
    def getType: ZIO[Any, Nothing, EngineType] = ZIO.succeed(`type`)
    def getState
        : ZIO[Any, Nothing, zio.aws.emrserverless.model.ApplicationState] =
      ZIO.succeed(state)
    def getStateDetails: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("stateDetails", stateDetails)
    def getCreatedAt: ZIO[Any, Nothing, Date] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Date] = ZIO.succeed(updatedAt)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.emrserverless.model.Architecture] =
      AwsError.unwrapOptionField("architecture", architecture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.ApplicationSummary
  ) extends zio.aws.emrserverless.model.ApplicationSummary.ReadOnly {
    override val id: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.id())
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.emrserverless.model.primitives.ApplicationName(value)
      )
    override val arn: ApplicationArn =
      zio.aws.emrserverless.model.primitives.ApplicationArn(impl.arn())
    override val releaseLabel: ReleaseLabel =
      zio.aws.emrserverless.model.primitives.ReleaseLabel(impl.releaseLabel())
    override val `type`: EngineType =
      zio.aws.emrserverless.model.primitives.EngineType(impl.`type`())
    override val state: zio.aws.emrserverless.model.ApplicationState =
      zio.aws.emrserverless.model.ApplicationState.wrap(impl.state())
    override val stateDetails: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.stateDetails())
      .map(value => zio.aws.emrserverless.model.primitives.String256(value))
    override val createdAt: Date =
      zio.aws.emrserverless.model.primitives.Date(impl.createdAt())
    override val updatedAt: Date =
      zio.aws.emrserverless.model.primitives.Date(impl.updatedAt())
    override val architecture
        : Optional[zio.aws.emrserverless.model.Architecture] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architecture())
        .map(value => zio.aws.emrserverless.model.Architecture.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.ApplicationSummary
  ): zio.aws.emrserverless.model.ApplicationSummary.ReadOnly = new Wrapper(impl)
}
