package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{
  WorkerTypeString,
  ClientToken,
  ApplicationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    applicationId: ApplicationId,
    clientToken: ClientToken,
    initialCapacity: Optional[
      Map[WorkerTypeString, zio.aws.emrserverless.model.InitialCapacityConfig]
    ] = Optional.Absent,
    maximumCapacity: Optional[
      zio.aws.emrserverless.model.MaximumAllowedResources
    ] = Optional.Absent,
    autoStartConfiguration: Optional[
      zio.aws.emrserverless.model.AutoStartConfig
    ] = Optional.Absent,
    autoStopConfiguration: Optional[
      zio.aws.emrserverless.model.AutoStopConfig
    ] = Optional.Absent,
    networkConfiguration: Optional[
      zio.aws.emrserverless.model.NetworkConfiguration
    ] = Optional.Absent,
    architecture: Optional[zio.aws.emrserverless.model.Architecture] =
      Optional.Absent,
    imageConfiguration: Optional[
      zio.aws.emrserverless.model.ImageConfigurationInput
    ] = Optional.Absent,
    workerTypeSpecifications: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.WorkerTypeSpecificationInput
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.UpdateApplicationRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        initialCapacity.map(value =>
          value
            .map({ case (key, value) =>
              (WorkerTypeString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.initialCapacity)
      .optionallyWith(maximumCapacity.map(value => value.buildAwsValue()))(
        _.maximumCapacity
      )
      .optionallyWith(
        autoStartConfiguration.map(value => value.buildAwsValue())
      )(_.autoStartConfiguration)
      .optionallyWith(
        autoStopConfiguration.map(value => value.buildAwsValue())
      )(_.autoStopConfiguration)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(imageConfiguration.map(value => value.buildAwsValue()))(
        _.imageConfiguration
      )
      .optionallyWith(
        workerTypeSpecifications.map(value =>
          value
            .map({ case (key, value) =>
              (WorkerTypeString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.workerTypeSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.emrserverless.model.UpdateApplicationRequest.wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.UpdateApplicationRequest =
      zio.aws.emrserverless.model.UpdateApplicationRequest(
        applicationId,
        clientToken,
        initialCapacity.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        maximumCapacity.map(value => value.asEditable),
        autoStartConfiguration.map(value => value.asEditable),
        autoStopConfiguration.map(value => value.asEditable),
        networkConfiguration.map(value => value.asEditable),
        architecture.map(value => value),
        imageConfiguration.map(value => value.asEditable),
        workerTypeSpecifications.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def applicationId: ApplicationId
    def clientToken: ClientToken
    def initialCapacity: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly
    ]]
    def maximumCapacity
        : Optional[zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly]
    def autoStartConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStartConfig.ReadOnly]
    def autoStopConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStopConfig.ReadOnly]
    def networkConfiguration
        : Optional[zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly]
    def architecture: Optional[zio.aws.emrserverless.model.Architecture]
    def imageConfiguration
        : Optional[zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly]
    def workerTypeSpecifications: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.WorkerTypeSpecificationInput.ReadOnly
    ]]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getInitialCapacity: ZIO[Any, AwsError, Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("initialCapacity", initialCapacity)
    def getMaximumCapacity: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly
    ] = AwsError.unwrapOptionField("maximumCapacity", maximumCapacity)
    def getAutoStartConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.AutoStartConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoStartConfiguration",
      autoStartConfiguration
    )
    def getAutoStopConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.AutoStopConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("autoStopConfiguration", autoStopConfiguration)
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.emrserverless.model.Architecture] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getImageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly
    ] = AwsError.unwrapOptionField("imageConfiguration", imageConfiguration)
    def getWorkerTypeSpecifications: ZIO[Any, AwsError, Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.WorkerTypeSpecificationInput.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "workerTypeSpecifications",
      workerTypeSpecifications
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.UpdateApplicationRequest
  ) extends zio.aws.emrserverless.model.UpdateApplicationRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val clientToken: ClientToken =
      zio.aws.emrserverless.model.primitives.ClientToken(impl.clientToken())
    override val initialCapacity: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.InitialCapacityConfig.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.initialCapacity())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emrserverless.model.primitives.WorkerTypeString(
              key
            ) -> zio.aws.emrserverless.model.InitialCapacityConfig.wrap(value)
          })
          .toMap
      )
    override val maximumCapacity: Optional[
      zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumCapacity())
      .map(value =>
        zio.aws.emrserverless.model.MaximumAllowedResources.wrap(value)
      )
    override val autoStartConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStartConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoStartConfiguration())
        .map(value => zio.aws.emrserverless.model.AutoStartConfig.wrap(value))
    override val autoStopConfiguration
        : Optional[zio.aws.emrserverless.model.AutoStopConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoStopConfiguration())
        .map(value => zio.aws.emrserverless.model.AutoStopConfig.wrap(value))
    override val networkConfiguration
        : Optional[zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value =>
          zio.aws.emrserverless.model.NetworkConfiguration.wrap(value)
        )
    override val architecture
        : Optional[zio.aws.emrserverless.model.Architecture] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architecture())
        .map(value => zio.aws.emrserverless.model.Architecture.wrap(value))
    override val imageConfiguration: Optional[
      zio.aws.emrserverless.model.ImageConfigurationInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.imageConfiguration())
      .map(value =>
        zio.aws.emrserverless.model.ImageConfigurationInput.wrap(value)
      )
    override val workerTypeSpecifications: Optional[Map[
      WorkerTypeString,
      zio.aws.emrserverless.model.WorkerTypeSpecificationInput.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.workerTypeSpecifications())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emrserverless.model.primitives.WorkerTypeString(
              key
            ) -> zio.aws.emrserverless.model.WorkerTypeSpecificationInput
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.UpdateApplicationRequest
  ): zio.aws.emrserverless.model.UpdateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
