package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{JobRunId, ApplicationId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelJobRunRequest(
    applicationId: ApplicationId,
    jobRunId: JobRunId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.CancelJobRunRequest = {
    import CancelJobRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.CancelJobRunRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .jobRunId(JobRunId.unwrap(jobRunId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.CancelJobRunRequest.ReadOnly =
    zio.aws.emrserverless.model.CancelJobRunRequest.wrap(buildAwsValue())
}
object CancelJobRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.CancelJobRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.CancelJobRunRequest =
      zio.aws.emrserverless.model.CancelJobRunRequest(applicationId, jobRunId)
    def applicationId: ApplicationId
    def jobRunId: JobRunId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getJobRunId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(jobRunId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.CancelJobRunRequest
  ) extends zio.aws.emrserverless.model.CancelJobRunRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val jobRunId: JobRunId =
      zio.aws.emrserverless.model.primitives.JobRunId(impl.jobRunId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.CancelJobRunRequest
  ): zio.aws.emrserverless.model.CancelJobRunRequest.ReadOnly = new Wrapper(
    impl
  )
}
