package zio.aws.emrserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoStartConfig(enabled: Optional[Boolean] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.AutoStartConfig = {
    import AutoStartConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.AutoStartConfig
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.AutoStartConfig.ReadOnly =
    zio.aws.emrserverless.model.AutoStartConfig.wrap(buildAwsValue())
}
object AutoStartConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.AutoStartConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.AutoStartConfig =
      zio.aws.emrserverless.model.AutoStartConfig(enabled.map(value => value))
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.AutoStartConfig
  ) extends zio.aws.emrserverless.model.AutoStartConfig.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.AutoStartConfig
  ): zio.aws.emrserverless.model.AutoStartConfig.ReadOnly = new Wrapper(impl)
}
