package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{DiskSize, MemorySize, CpuSize}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WorkerResourceConfig(
    cpu: CpuSize,
    memory: MemorySize,
    disk: Optional[DiskSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.WorkerResourceConfig = {
    import WorkerResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.WorkerResourceConfig
      .builder()
      .cpu(CpuSize.unwrap(cpu): java.lang.String)
      .memory(MemorySize.unwrap(memory): java.lang.String)
      .optionallyWith(
        disk.map(value => DiskSize.unwrap(value): java.lang.String)
      )(_.disk)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.WorkerResourceConfig.ReadOnly =
    zio.aws.emrserverless.model.WorkerResourceConfig.wrap(buildAwsValue())
}
object WorkerResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.WorkerResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.WorkerResourceConfig =
      zio.aws.emrserverless.model
        .WorkerResourceConfig(cpu, memory, disk.map(value => value))
    def cpu: CpuSize
    def memory: MemorySize
    def disk: Optional[DiskSize]
    def getCpu: ZIO[Any, Nothing, CpuSize] = ZIO.succeed(cpu)
    def getMemory: ZIO[Any, Nothing, MemorySize] = ZIO.succeed(memory)
    def getDisk: ZIO[Any, AwsError, DiskSize] =
      AwsError.unwrapOptionField("disk", disk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.WorkerResourceConfig
  ) extends zio.aws.emrserverless.model.WorkerResourceConfig.ReadOnly {
    override val cpu: CpuSize =
      zio.aws.emrserverless.model.primitives.CpuSize(impl.cpu())
    override val memory: MemorySize =
      zio.aws.emrserverless.model.primitives.MemorySize(impl.memory())
    override val disk: Optional[DiskSize] = zio.aws.core.internal
      .optionalFromNullable(impl.disk())
      .map(value => zio.aws.emrserverless.model.primitives.DiskSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.WorkerResourceConfig
  ): zio.aws.emrserverless.model.WorkerResourceConfig.ReadOnly = new Wrapper(
    impl
  )
}
