package zio.aws.emrserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emrserverless.model.primitives.{
  Date,
  ListJobRunsRequestMaxResultsInteger,
  NextToken,
  ApplicationId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListJobRunsRequest(
    applicationId: ApplicationId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListJobRunsRequestMaxResultsInteger] = Optional.Absent,
    createdAtAfter: Optional[Date] = Optional.Absent,
    createdAtBefore: Optional[Date] = Optional.Absent,
    states: Optional[Iterable[zio.aws.emrserverless.model.JobRunState]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.ListJobRunsRequest = {
    import ListJobRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.ListJobRunsRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListJobRunsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(createdAtAfter.map(value => Date.unwrap(value): Instant))(
        _.createdAtAfter
      )
      .optionallyWith(
        createdAtBefore.map(value => Date.unwrap(value): Instant)
      )(_.createdAtBefore)
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.ListJobRunsRequest.ReadOnly =
    zio.aws.emrserverless.model.ListJobRunsRequest.wrap(buildAwsValue())
}
object ListJobRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.ListJobRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.ListJobRunsRequest =
      zio.aws.emrserverless.model.ListJobRunsRequest(
        applicationId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        createdAtAfter.map(value => value),
        createdAtBefore.map(value => value),
        states.map(value => value)
      )
    def applicationId: ApplicationId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListJobRunsRequestMaxResultsInteger]
    def createdAtAfter: Optional[Date]
    def createdAtBefore: Optional[Date]
    def states: Optional[List[zio.aws.emrserverless.model.JobRunState]]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListJobRunsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getCreatedAtAfter: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdAtAfter", createdAtAfter)
    def getCreatedAtBefore: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdAtBefore", createdAtBefore)
    def getStates
        : ZIO[Any, AwsError, List[zio.aws.emrserverless.model.JobRunState]] =
      AwsError.unwrapOptionField("states", states)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.ListJobRunsRequest
  ) extends zio.aws.emrserverless.model.ListJobRunsRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.emrserverless.model.primitives.NextToken(value))
    override val maxResults: Optional[ListJobRunsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.emrserverless.model.primitives
            .ListJobRunsRequestMaxResultsInteger(value)
        )
    override val createdAtAfter: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAtAfter())
      .map(value => zio.aws.emrserverless.model.primitives.Date(value))
    override val createdAtBefore: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAtBefore())
      .map(value => zio.aws.emrserverless.model.primitives.Date(value))
    override val states
        : Optional[List[zio.aws.emrserverless.model.JobRunState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.states())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emrserverless.model.JobRunState.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.ListJobRunsRequest
  ): zio.aws.emrserverless.model.ListJobRunsRequest.ReadOnly = new Wrapper(impl)
}
