package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{
  IAMRoleArn,
  TagValue,
  ClientToken,
  Duration,
  ApplicationId,
  String256,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartJobRunRequest(
    applicationId: ApplicationId,
    clientToken: ClientToken,
    executionRoleArn: IAMRoleArn,
    jobDriver: Optional[zio.aws.emrserverless.model.JobDriver] =
      Optional.Absent,
    configurationOverrides: Optional[
      zio.aws.emrserverless.model.ConfigurationOverrides
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    executionTimeoutMinutes: Optional[Duration] = Optional.Absent,
    name: Optional[String256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.StartJobRunRequest = {
    import StartJobRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.StartJobRunRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .executionRoleArn(IAMRoleArn.unwrap(executionRoleArn): java.lang.String)
      .optionallyWith(jobDriver.map(value => value.buildAwsValue()))(
        _.jobDriver
      )
      .optionallyWith(
        configurationOverrides.map(value => value.buildAwsValue())
      )(_.configurationOverrides)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        executionTimeoutMinutes.map(value =>
          Duration.unwrap(value): java.lang.Long
        )
      )(_.executionTimeoutMinutes)
      .optionallyWith(
        name.map(value => String256.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.StartJobRunRequest.ReadOnly =
    zio.aws.emrserverless.model.StartJobRunRequest.wrap(buildAwsValue())
}
object StartJobRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.StartJobRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.StartJobRunRequest =
      zio.aws.emrserverless.model.StartJobRunRequest(
        applicationId,
        clientToken,
        executionRoleArn,
        jobDriver.map(value => value.asEditable),
        configurationOverrides.map(value => value.asEditable),
        tags.map(value => value),
        executionTimeoutMinutes.map(value => value),
        name.map(value => value)
      )
    def applicationId: ApplicationId
    def clientToken: ClientToken
    def executionRoleArn: IAMRoleArn
    def jobDriver: Optional[zio.aws.emrserverless.model.JobDriver.ReadOnly]
    def configurationOverrides
        : Optional[zio.aws.emrserverless.model.ConfigurationOverrides.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def executionTimeoutMinutes: Optional[Duration]
    def name: Optional[String256]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getExecutionRoleArn: ZIO[Any, Nothing, IAMRoleArn] =
      ZIO.succeed(executionRoleArn)
    def getJobDriver
        : ZIO[Any, AwsError, zio.aws.emrserverless.model.JobDriver.ReadOnly] =
      AwsError.unwrapOptionField("jobDriver", jobDriver)
    def getConfigurationOverrides: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.ConfigurationOverrides.ReadOnly
    ] = AwsError.unwrapOptionField(
      "configurationOverrides",
      configurationOverrides
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getExecutionTimeoutMinutes: ZIO[Any, AwsError, Duration] = AwsError
      .unwrapOptionField("executionTimeoutMinutes", executionTimeoutMinutes)
    def getName: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.StartJobRunRequest
  ) extends zio.aws.emrserverless.model.StartJobRunRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val clientToken: ClientToken =
      zio.aws.emrserverless.model.primitives.ClientToken(impl.clientToken())
    override val executionRoleArn: IAMRoleArn =
      zio.aws.emrserverless.model.primitives.IAMRoleArn(impl.executionRoleArn())
    override val jobDriver
        : Optional[zio.aws.emrserverless.model.JobDriver.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDriver())
        .map(value => zio.aws.emrserverless.model.JobDriver.wrap(value))
    override val configurationOverrides: Optional[
      zio.aws.emrserverless.model.ConfigurationOverrides.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationOverrides())
      .map(value =>
        zio.aws.emrserverless.model.ConfigurationOverrides.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emrserverless.model.primitives.TagKey(
              key
            ) -> zio.aws.emrserverless.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val executionTimeoutMinutes: Optional[Duration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionTimeoutMinutes())
        .map(value => zio.aws.emrserverless.model.primitives.Duration(value))
    override val name: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emrserverless.model.primitives.String256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.StartJobRunRequest
  ): zio.aws.emrserverless.model.StartJobRunRequest.ReadOnly = new Wrapper(impl)
}
