package zio.aws.emrserverless.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationState {
  def unwrap
      : software.amazon.awssdk.services.emrserverless.model.ApplicationState
}
object ApplicationState {
  def wrap(
      value: software.amazon.awssdk.services.emrserverless.model.ApplicationState
  ): zio.aws.emrserverless.model.ApplicationState = value match {
    case software.amazon.awssdk.services.emrserverless.model.ApplicationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emrserverless.model.ApplicationState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.emrserverless.model.ApplicationState.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.emrserverless.model.ApplicationState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.emrserverless.model.ApplicationState.STARTED =>
      val r = STARTED
      r
    case software.amazon.awssdk.services.emrserverless.model.ApplicationState.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.emrserverless.model.ApplicationState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.emrserverless.model.ApplicationState.TERMINATED =>
      val r = TERMINATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emrserverless.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.ApplicationState =
      software.amazon.awssdk.services.emrserverless.model.ApplicationState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.emrserverless.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.ApplicationState =
      software.amazon.awssdk.services.emrserverless.model.ApplicationState.CREATING
  }
  case object CREATED extends zio.aws.emrserverless.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.ApplicationState =
      software.amazon.awssdk.services.emrserverless.model.ApplicationState.CREATED
  }
  case object STARTING extends zio.aws.emrserverless.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.ApplicationState =
      software.amazon.awssdk.services.emrserverless.model.ApplicationState.STARTING
  }
  case object STARTED extends zio.aws.emrserverless.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.ApplicationState =
      software.amazon.awssdk.services.emrserverless.model.ApplicationState.STARTED
  }
  case object STOPPING extends zio.aws.emrserverless.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.ApplicationState =
      software.amazon.awssdk.services.emrserverless.model.ApplicationState.STOPPING
  }
  case object STOPPED extends zio.aws.emrserverless.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.ApplicationState =
      software.amazon.awssdk.services.emrserverless.model.ApplicationState.STOPPED
  }
  case object TERMINATED extends zio.aws.emrserverless.model.ApplicationState {
    override def unwrap
        : software.amazon.awssdk.services.emrserverless.model.ApplicationState =
      software.amazon.awssdk.services.emrserverless.model.ApplicationState.TERMINATED
  }
}
