package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.Url
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDashboardForJobRunResponse(
    url: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunResponse = {
    import GetDashboardForJobRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunResponse
      .builder()
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.GetDashboardForJobRunResponse.ReadOnly =
    zio.aws.emrserverless.model.GetDashboardForJobRunResponse
      .wrap(buildAwsValue())
}
object GetDashboardForJobRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.GetDashboardForJobRunResponse =
      zio.aws.emrserverless.model
        .GetDashboardForJobRunResponse(url.map(value => value))
    def url: Optional[Url]
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunResponse
  ) extends zio.aws.emrserverless.model.GetDashboardForJobRunResponse.ReadOnly {
    override val url: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.emrserverless.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.GetDashboardForJobRunResponse
  ): zio.aws.emrserverless.model.GetDashboardForJobRunResponse.ReadOnly =
    new Wrapper(impl)
}
