package zio.aws.emrserverless.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emrserverless.model.primitives.{
  IAMRoleArn,
  JobRunId,
  Date,
  JobArn,
  TagValue,
  Integer,
  ReleaseLabel,
  RequestIdentityUserArn,
  ApplicationId,
  String256,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class JobRun(
    applicationId: ApplicationId,
    jobRunId: JobRunId,
    name: Optional[String256] = Optional.Absent,
    arn: JobArn,
    createdBy: RequestIdentityUserArn,
    createdAt: Date,
    updatedAt: Date,
    executionRole: IAMRoleArn,
    state: zio.aws.emrserverless.model.JobRunState,
    stateDetails: String256,
    releaseLabel: ReleaseLabel,
    configurationOverrides: Optional[
      zio.aws.emrserverless.model.ConfigurationOverrides
    ] = Optional.Absent,
    jobDriver: zio.aws.emrserverless.model.JobDriver,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    totalResourceUtilization: Optional[
      zio.aws.emrserverless.model.TotalResourceUtilization
    ] = Optional.Absent,
    networkConfiguration: Optional[
      zio.aws.emrserverless.model.NetworkConfiguration
    ] = Optional.Absent,
    totalExecutionDurationSeconds: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.JobRun = {
    import JobRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.JobRun
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .jobRunId(JobRunId.unwrap(jobRunId): java.lang.String)
      .optionallyWith(
        name.map(value => String256.unwrap(value): java.lang.String)
      )(_.name)
      .arn(JobArn.unwrap(arn): java.lang.String)
      .createdBy(RequestIdentityUserArn.unwrap(createdBy): java.lang.String)
      .createdAt(Date.unwrap(createdAt): Instant)
      .updatedAt(Date.unwrap(updatedAt): Instant)
      .executionRole(IAMRoleArn.unwrap(executionRole): java.lang.String)
      .state(state.unwrap)
      .stateDetails(String256.unwrap(stateDetails): java.lang.String)
      .releaseLabel(ReleaseLabel.unwrap(releaseLabel): java.lang.String)
      .optionallyWith(
        configurationOverrides.map(value => value.buildAwsValue())
      )(_.configurationOverrides)
      .jobDriver(jobDriver.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        totalResourceUtilization.map(value => value.buildAwsValue())
      )(_.totalResourceUtilization)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        totalExecutionDurationSeconds.map(value => value: java.lang.Integer)
      )(_.totalExecutionDurationSeconds)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.JobRun.ReadOnly =
    zio.aws.emrserverless.model.JobRun.wrap(buildAwsValue())
}
object JobRun {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.JobRun
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.JobRun =
      zio.aws.emrserverless.model.JobRun(
        applicationId,
        jobRunId,
        name.map(value => value),
        arn,
        createdBy,
        createdAt,
        updatedAt,
        executionRole,
        state,
        stateDetails,
        releaseLabel,
        configurationOverrides.map(value => value.asEditable),
        jobDriver.asEditable,
        tags.map(value => value),
        totalResourceUtilization.map(value => value.asEditable),
        networkConfiguration.map(value => value.asEditable),
        totalExecutionDurationSeconds.map(value => value)
      )
    def applicationId: ApplicationId
    def jobRunId: JobRunId
    def name: Optional[String256]
    def arn: JobArn
    def createdBy: RequestIdentityUserArn
    def createdAt: Date
    def updatedAt: Date
    def executionRole: IAMRoleArn
    def state: zio.aws.emrserverless.model.JobRunState
    def stateDetails: String256
    def releaseLabel: ReleaseLabel
    def configurationOverrides
        : Optional[zio.aws.emrserverless.model.ConfigurationOverrides.ReadOnly]
    def jobDriver: zio.aws.emrserverless.model.JobDriver.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def totalResourceUtilization: Optional[
      zio.aws.emrserverless.model.TotalResourceUtilization.ReadOnly
    ]
    def networkConfiguration
        : Optional[zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly]
    def totalExecutionDurationSeconds: Optional[Integer]
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getJobRunId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(jobRunId)
    def getName: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, Nothing, JobArn] = ZIO.succeed(arn)
    def getCreatedBy: ZIO[Any, Nothing, RequestIdentityUserArn] =
      ZIO.succeed(createdBy)
    def getCreatedAt: ZIO[Any, Nothing, Date] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Date] = ZIO.succeed(updatedAt)
    def getExecutionRole: ZIO[Any, Nothing, IAMRoleArn] =
      ZIO.succeed(executionRole)
    def getState: ZIO[Any, Nothing, zio.aws.emrserverless.model.JobRunState] =
      ZIO.succeed(state)
    def getStateDetails: ZIO[Any, Nothing, String256] =
      ZIO.succeed(stateDetails)
    def getReleaseLabel: ZIO[Any, Nothing, ReleaseLabel] =
      ZIO.succeed(releaseLabel)
    def getConfigurationOverrides: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.ConfigurationOverrides.ReadOnly
    ] = AwsError.unwrapOptionField(
      "configurationOverrides",
      configurationOverrides
    )
    def getJobDriver
        : ZIO[Any, Nothing, zio.aws.emrserverless.model.JobDriver.ReadOnly] =
      ZIO.succeed(jobDriver)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTotalResourceUtilization: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.TotalResourceUtilization.ReadOnly
    ] = AwsError.unwrapOptionField(
      "totalResourceUtilization",
      totalResourceUtilization
    )
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getTotalExecutionDurationSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "totalExecutionDurationSeconds",
        totalExecutionDurationSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.JobRun
  ) extends zio.aws.emrserverless.model.JobRun.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val jobRunId: JobRunId =
      zio.aws.emrserverless.model.primitives.JobRunId(impl.jobRunId())
    override val name: Optional[String256] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.emrserverless.model.primitives.String256(value))
    override val arn: JobArn =
      zio.aws.emrserverless.model.primitives.JobArn(impl.arn())
    override val createdBy: RequestIdentityUserArn =
      zio.aws.emrserverless.model.primitives
        .RequestIdentityUserArn(impl.createdBy())
    override val createdAt: Date =
      zio.aws.emrserverless.model.primitives.Date(impl.createdAt())
    override val updatedAt: Date =
      zio.aws.emrserverless.model.primitives.Date(impl.updatedAt())
    override val executionRole: IAMRoleArn =
      zio.aws.emrserverless.model.primitives.IAMRoleArn(impl.executionRole())
    override val state: zio.aws.emrserverless.model.JobRunState =
      zio.aws.emrserverless.model.JobRunState.wrap(impl.state())
    override val stateDetails: String256 =
      zio.aws.emrserverless.model.primitives.String256(impl.stateDetails())
    override val releaseLabel: ReleaseLabel =
      zio.aws.emrserverless.model.primitives.ReleaseLabel(impl.releaseLabel())
    override val configurationOverrides: Optional[
      zio.aws.emrserverless.model.ConfigurationOverrides.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationOverrides())
      .map(value =>
        zio.aws.emrserverless.model.ConfigurationOverrides.wrap(value)
      )
    override val jobDriver: zio.aws.emrserverless.model.JobDriver.ReadOnly =
      zio.aws.emrserverless.model.JobDriver.wrap(impl.jobDriver())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.emrserverless.model.primitives.TagKey(
              key
            ) -> zio.aws.emrserverless.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val totalResourceUtilization: Optional[
      zio.aws.emrserverless.model.TotalResourceUtilization.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.totalResourceUtilization())
      .map(value =>
        zio.aws.emrserverless.model.TotalResourceUtilization.wrap(value)
      )
    override val networkConfiguration
        : Optional[zio.aws.emrserverless.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value =>
          zio.aws.emrserverless.model.NetworkConfiguration.wrap(value)
        )
    override val totalExecutionDurationSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalExecutionDurationSeconds())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.JobRun
  ): zio.aws.emrserverless.model.JobRun.ReadOnly = new Wrapper(impl)
}
