package zio.aws.emrserverless
import zio.aws.emrserverless.model.ApplicationSummary.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.emrserverless.paginators.{
  ListApplicationsPublisher,
  ListJobRunsPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.emrserverless.{
  EmrServerlessAsyncClientBuilder,
  EmrServerlessAsyncClient
}
import software.amazon.awssdk.services.emrserverless.model.{
  UpdateApplicationRequest,
  DeleteApplicationRequest,
  ListJobRunsRequest,
  GetJobRunResponse,
  StartJobRunRequest,
  StartApplicationRequest,
  UpdateApplicationResponse,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  StartApplicationResponse,
  GetJobRunRequest,
  ListJobRunsResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CancelJobRunResponse,
  ListApplicationsResponse,
  GetApplicationRequest,
  CreateApplicationResponse,
  StopApplicationResponse,
  UntagResourceRequest,
  ListApplicationsRequest,
  CancelJobRunRequest,
  StopApplicationRequest,
  StartJobRunResponse,
  TagResourceResponse,
  ApplicationSummary,
  GetApplicationResponse,
  JobRunSummary,
  DeleteApplicationResponse,
  TagResourceRequest
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait EmrServerless extends AspectSupport[EmrServerless] {
  val api: EmrServerlessAsyncClient
  def getApplication(
      request: zio.aws.emrserverless.model.GetApplicationRequest
  ): IO[AwsError, zio.aws.emrserverless.model.GetApplicationResponse.ReadOnly]
  def deleteApplication(
      request: zio.aws.emrserverless.model.DeleteApplicationRequest
  ): IO[
    AwsError,
    zio.aws.emrserverless.model.DeleteApplicationResponse.ReadOnly
  ]
  def listJobRuns(
      request: zio.aws.emrserverless.model.ListJobRunsRequest
  ): ZStream[Any, AwsError, zio.aws.emrserverless.model.JobRunSummary.ReadOnly]
  def listJobRunsPaginated(
      request: zio.aws.emrserverless.model.ListJobRunsRequest
  ): IO[AwsError, zio.aws.emrserverless.model.ListJobRunsResponse.ReadOnly]
  def createApplication(
      request: zio.aws.emrserverless.model.CreateApplicationRequest
  ): IO[
    AwsError,
    zio.aws.emrserverless.model.CreateApplicationResponse.ReadOnly
  ]
  def cancelJobRun(
      request: zio.aws.emrserverless.model.CancelJobRunRequest
  ): IO[AwsError, zio.aws.emrserverless.model.CancelJobRunResponse.ReadOnly]
  def startApplication(
      request: zio.aws.emrserverless.model.StartApplicationRequest
  ): IO[AwsError, zio.aws.emrserverless.model.StartApplicationResponse.ReadOnly]
  def untagResource(
      request: zio.aws.emrserverless.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.emrserverless.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.emrserverless.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.emrserverless.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.emrserverless.model.TagResourceRequest
  ): IO[AwsError, zio.aws.emrserverless.model.TagResourceResponse.ReadOnly]
  def getJobRun(
      request: zio.aws.emrserverless.model.GetJobRunRequest
  ): IO[AwsError, zio.aws.emrserverless.model.GetJobRunResponse.ReadOnly]
  def listApplications(
      request: zio.aws.emrserverless.model.ListApplicationsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listApplicationsPaginated(
      request: zio.aws.emrserverless.model.ListApplicationsRequest
  ): IO[AwsError, zio.aws.emrserverless.model.ListApplicationsResponse.ReadOnly]
  def updateApplication(
      request: zio.aws.emrserverless.model.UpdateApplicationRequest
  ): IO[
    AwsError,
    zio.aws.emrserverless.model.UpdateApplicationResponse.ReadOnly
  ]
  def startJobRun(
      request: zio.aws.emrserverless.model.StartJobRunRequest
  ): IO[AwsError, zio.aws.emrserverless.model.StartJobRunResponse.ReadOnly]
  def stopApplication(
      request: zio.aws.emrserverless.model.StopApplicationRequest
  ): IO[AwsError, zio.aws.emrserverless.model.StopApplicationResponse.ReadOnly]
}
object EmrServerless {
  val live: ZLayer[AwsConfig, java.lang.Throwable, EmrServerless] = customized(
    identity
  )
  def customized(
      customization: EmrServerlessAsyncClientBuilder => EmrServerlessAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, EmrServerless] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: EmrServerlessAsyncClientBuilder => EmrServerlessAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, EmrServerless] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = EmrServerlessAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[EmrServerlessAsyncClient, EmrServerlessAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      EmrServerlessAsyncClient,
      EmrServerlessAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new EmrServerlessImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class EmrServerlessImpl[R](
      override val api: EmrServerlessAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends EmrServerless
      with AwsServiceBase[R] {
    override val serviceName: String = "EmrServerless"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): EmrServerlessImpl[R1] = new EmrServerlessImpl(api, newAspect, r)
    def getApplication(
        request: zio.aws.emrserverless.model.GetApplicationRequest
    ): IO[
      AwsError,
      zio.aws.emrserverless.model.GetApplicationResponse.ReadOnly
    ] = asyncRequestResponse[GetApplicationRequest, GetApplicationResponse](
      "getApplication",
      api.getApplication
    )(request.buildAwsValue())
      .map(zio.aws.emrserverless.model.GetApplicationResponse.wrap)
      .provideEnvironment(r)
    def deleteApplication(
        request: zio.aws.emrserverless.model.DeleteApplicationRequest
    ): IO[
      AwsError,
      zio.aws.emrserverless.model.DeleteApplicationResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteApplicationRequest, DeleteApplicationResponse](
        "deleteApplication",
        api.deleteApplication
      )(request.buildAwsValue())
        .map(zio.aws.emrserverless.model.DeleteApplicationResponse.wrap)
        .provideEnvironment(r)
    def listJobRuns(
        request: zio.aws.emrserverless.model.ListJobRunsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.emrserverless.model.JobRunSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListJobRunsRequest,
      JobRunSummary,
      ListJobRunsPublisher
    ]("listJobRuns", api.listJobRunsPaginator, _.jobRuns())(
      request.buildAwsValue()
    ).map(item => zio.aws.emrserverless.model.JobRunSummary.wrap(item))
      .provideEnvironment(r)
    def listJobRunsPaginated(
        request: zio.aws.emrserverless.model.ListJobRunsRequest
    ): IO[AwsError, zio.aws.emrserverless.model.ListJobRunsResponse.ReadOnly] =
      asyncRequestResponse[ListJobRunsRequest, ListJobRunsResponse](
        "listJobRuns",
        api.listJobRuns
      )(request.buildAwsValue())
        .map(zio.aws.emrserverless.model.ListJobRunsResponse.wrap)
        .provideEnvironment(r)
    def createApplication(
        request: zio.aws.emrserverless.model.CreateApplicationRequest
    ): IO[
      AwsError,
      zio.aws.emrserverless.model.CreateApplicationResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateApplicationRequest, CreateApplicationResponse](
        "createApplication",
        api.createApplication
      )(request.buildAwsValue())
        .map(zio.aws.emrserverless.model.CreateApplicationResponse.wrap)
        .provideEnvironment(r)
    def cancelJobRun(
        request: zio.aws.emrserverless.model.CancelJobRunRequest
    ): IO[AwsError, zio.aws.emrserverless.model.CancelJobRunResponse.ReadOnly] =
      asyncRequestResponse[CancelJobRunRequest, CancelJobRunResponse](
        "cancelJobRun",
        api.cancelJobRun
      )(request.buildAwsValue())
        .map(zio.aws.emrserverless.model.CancelJobRunResponse.wrap)
        .provideEnvironment(r)
    def startApplication(
        request: zio.aws.emrserverless.model.StartApplicationRequest
    ): IO[
      AwsError,
      zio.aws.emrserverless.model.StartApplicationResponse.ReadOnly
    ] = asyncRequestResponse[StartApplicationRequest, StartApplicationResponse](
      "startApplication",
      api.startApplication
    )(request.buildAwsValue())
      .map(zio.aws.emrserverless.model.StartApplicationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.emrserverless.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.emrserverless.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.emrserverless.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.emrserverless.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.emrserverless.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.emrserverless.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.emrserverless.model.TagResourceRequest
    ): IO[AwsError, zio.aws.emrserverless.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.emrserverless.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getJobRun(
        request: zio.aws.emrserverless.model.GetJobRunRequest
    ): IO[AwsError, zio.aws.emrserverless.model.GetJobRunResponse.ReadOnly] =
      asyncRequestResponse[GetJobRunRequest, GetJobRunResponse](
        "getJobRun",
        api.getJobRun
      )(request.buildAwsValue())
        .map(zio.aws.emrserverless.model.GetJobRunResponse.wrap)
        .provideEnvironment(r)
    def listApplications(
        request: zio.aws.emrserverless.model.ListApplicationsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      ListApplicationsRequest,
      ApplicationSummary,
      ListApplicationsPublisher
    ]("listApplications", api.listApplicationsPaginator, _.applications())(
      request.buildAwsValue()
    ).map(item => zio.aws.emrserverless.model.ApplicationSummary.wrap(item))
      .provideEnvironment(r)
    def listApplicationsPaginated(
        request: zio.aws.emrserverless.model.ListApplicationsRequest
    ): IO[
      AwsError,
      zio.aws.emrserverless.model.ListApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[ListApplicationsRequest, ListApplicationsResponse](
      "listApplications",
      api.listApplications
    )(request.buildAwsValue())
      .map(zio.aws.emrserverless.model.ListApplicationsResponse.wrap)
      .provideEnvironment(r)
    def updateApplication(
        request: zio.aws.emrserverless.model.UpdateApplicationRequest
    ): IO[
      AwsError,
      zio.aws.emrserverless.model.UpdateApplicationResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateApplicationRequest, UpdateApplicationResponse](
        "updateApplication",
        api.updateApplication
      )(request.buildAwsValue())
        .map(zio.aws.emrserverless.model.UpdateApplicationResponse.wrap)
        .provideEnvironment(r)
    def startJobRun(
        request: zio.aws.emrserverless.model.StartJobRunRequest
    ): IO[AwsError, zio.aws.emrserverless.model.StartJobRunResponse.ReadOnly] =
      asyncRequestResponse[StartJobRunRequest, StartJobRunResponse](
        "startJobRun",
        api.startJobRun
      )(request.buildAwsValue())
        .map(zio.aws.emrserverless.model.StartJobRunResponse.wrap)
        .provideEnvironment(r)
    def stopApplication(
        request: zio.aws.emrserverless.model.StopApplicationRequest
    ): IO[
      AwsError,
      zio.aws.emrserverless.model.StopApplicationResponse.ReadOnly
    ] = asyncRequestResponse[StopApplicationRequest, StopApplicationResponse](
      "stopApplication",
      api.stopApplication
    )(request.buildAwsValue())
      .map(zio.aws.emrserverless.model.StopApplicationResponse.wrap)
      .provideEnvironment(r)
  }
  def getApplication(
      request: zio.aws.emrserverless.model.GetApplicationRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.GetApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplication(request))
  def deleteApplication(
      request: zio.aws.emrserverless.model.DeleteApplicationRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.DeleteApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplication(request))
  def listJobRuns(
      request: zio.aws.emrserverless.model.ListJobRunsRequest
  ): ZStream[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.JobRunSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobRuns(request))
  def listJobRunsPaginated(
      request: zio.aws.emrserverless.model.ListJobRunsRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.ListJobRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobRunsPaginated(request))
  def createApplication(
      request: zio.aws.emrserverless.model.CreateApplicationRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def cancelJobRun(
      request: zio.aws.emrserverless.model.CancelJobRunRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.CancelJobRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelJobRun(request))
  def startApplication(
      request: zio.aws.emrserverless.model.StartApplicationRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.StartApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startApplication(request))
  def untagResource(
      request: zio.aws.emrserverless.model.UntagResourceRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(
      request: zio.aws.emrserverless.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.emrserverless.model.TagResourceRequest): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getJobRun(request: zio.aws.emrserverless.model.GetJobRunRequest): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.GetJobRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJobRun(request))
  def listApplications(
      request: zio.aws.emrserverless.model.ListApplicationsRequest
  ): ZStream[zio.aws.emrserverless.EmrServerless, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(
      request: zio.aws.emrserverless.model.ListApplicationsRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def updateApplication(
      request: zio.aws.emrserverless.model.UpdateApplicationRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.UpdateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
  def startJobRun(request: zio.aws.emrserverless.model.StartJobRunRequest): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.StartJobRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startJobRun(request))
  def stopApplication(
      request: zio.aws.emrserverless.model.StopApplicationRequest
  ): ZIO[
    zio.aws.emrserverless.EmrServerless,
    AwsError,
    zio.aws.emrserverless.model.StopApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopApplication(request))
}
