package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{JobRunId, ApplicationId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetJobRunRequest(
    applicationId: ApplicationId,
    jobRunId: JobRunId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.GetJobRunRequest = {
    import GetJobRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.GetJobRunRequest
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .jobRunId(JobRunId.unwrap(jobRunId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.GetJobRunRequest.ReadOnly =
    zio.aws.emrserverless.model.GetJobRunRequest.wrap(buildAwsValue())
}
object GetJobRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.GetJobRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.GetJobRunRequest =
      zio.aws.emrserverless.model.GetJobRunRequest(applicationId, jobRunId)
    def applicationId: ApplicationId
    def jobRunId: JobRunId
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getJobRunId: ZIO[Any, Nothing, JobRunId] = ZIO.succeed(jobRunId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.GetJobRunRequest
  ) extends zio.aws.emrserverless.model.GetJobRunRequest.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val jobRunId: JobRunId =
      zio.aws.emrserverless.model.primitives.JobRunId(impl.jobRunId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.GetJobRunRequest
  ): zio.aws.emrserverless.model.GetJobRunRequest.ReadOnly = new Wrapper(impl)
}
