package zio.aws.emrserverless
import zio.aws.emrserverless.model.ApplicationSummary.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.emrserverless.EmrServerlessAsyncClient
import zio.stream.ZStream
import zio.aws.emrserverless.model.{
  UpdateApplicationRequest,
  DeleteApplicationRequest,
  ListJobRunsRequest,
  StartJobRunRequest,
  StartApplicationRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  GetJobRunRequest,
  GetApplicationRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  CancelJobRunRequest,
  StopApplicationRequest,
  TagResourceRequest
}
object EmrServerlessMock extends Mock[EmrServerless] {
  object GetApplication
      extends Effect[
        GetApplicationRequest,
        AwsError,
        zio.aws.emrserverless.model.GetApplicationResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[
        DeleteApplicationRequest,
        AwsError,
        zio.aws.emrserverless.model.DeleteApplicationResponse.ReadOnly
      ]
  object ListJobRuns
      extends Stream[
        ListJobRunsRequest,
        AwsError,
        zio.aws.emrserverless.model.JobRunSummary.ReadOnly
      ]
  object ListJobRunsPaginated
      extends Effect[
        ListJobRunsRequest,
        AwsError,
        zio.aws.emrserverless.model.ListJobRunsResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.emrserverless.model.CreateApplicationResponse.ReadOnly
      ]
  object CancelJobRun
      extends Effect[
        CancelJobRunRequest,
        AwsError,
        zio.aws.emrserverless.model.CancelJobRunResponse.ReadOnly
      ]
  object StartApplication
      extends Effect[
        StartApplicationRequest,
        AwsError,
        zio.aws.emrserverless.model.StartApplicationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.emrserverless.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.emrserverless.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.emrserverless.model.TagResourceResponse.ReadOnly
      ]
  object GetJobRun
      extends Effect[
        GetJobRunRequest,
        AwsError,
        zio.aws.emrserverless.model.GetJobRunResponse.ReadOnly
      ]
  object ListApplications
      extends Stream[ListApplicationsRequest, AwsError, ReadOnly]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.emrserverless.model.ListApplicationsResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.emrserverless.model.UpdateApplicationResponse.ReadOnly
      ]
  object StartJobRun
      extends Effect[
        StartJobRunRequest,
        AwsError,
        zio.aws.emrserverless.model.StartJobRunResponse.ReadOnly
      ]
  object StopApplication
      extends Effect[
        StopApplicationRequest,
        AwsError,
        zio.aws.emrserverless.model.StopApplicationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, EmrServerless] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, EmrServerless] { rts =>
        zio.ZIO.succeed {
          new EmrServerless {
            val api: EmrServerlessAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): EmrServerless = this
            def getApplication(request: GetApplicationRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.GetApplicationResponse.ReadOnly
            ] = proxy(GetApplication, request)
            def deleteApplication(request: DeleteApplicationRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.DeleteApplicationResponse.ReadOnly
            ] = proxy(DeleteApplication, request)
            def listJobRuns(request: ListJobRunsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.emrserverless.model.JobRunSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListJobRuns, request)
                }
                .getOrThrowFiberFailure()
            }
            def listJobRunsPaginated(request: ListJobRunsRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.ListJobRunsResponse.ReadOnly
            ] = proxy(ListJobRunsPaginated, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def cancelJobRun(request: CancelJobRunRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.CancelJobRunResponse.ReadOnly
            ] = proxy(CancelJobRun, request)
            def startApplication(request: StartApplicationRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.StartApplicationResponse.ReadOnly
            ] = proxy(StartApplication, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getJobRun(request: GetJobRunRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.GetJobRunResponse.ReadOnly
            ] = proxy(GetJobRun, request)
            def listApplications(
                request: ListApplicationsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListApplications, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def updateApplication(request: UpdateApplicationRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.UpdateApplicationResponse.ReadOnly
            ] = proxy(UpdateApplication, request)
            def startJobRun(request: StartJobRunRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.StartJobRunResponse.ReadOnly
            ] = proxy(StartJobRun, request)
            def stopApplication(request: StopApplicationRequest): IO[
              AwsError,
              zio.aws.emrserverless.model.StopApplicationResponse.ReadOnly
            ] = proxy(StopApplication, request)
          }
        }
      }
    }
  }
}
