package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{
  SparkSubmitParameters,
  EntryPointArgument,
  EntryPointPath
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SparkSubmit(
    entryPoint: EntryPointPath,
    entryPointArguments: Optional[Iterable[EntryPointArgument]] =
      Optional.Absent,
    sparkSubmitParameters: Optional[SparkSubmitParameters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.SparkSubmit = {
    import SparkSubmit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.SparkSubmit
      .builder()
      .entryPoint(EntryPointPath.unwrap(entryPoint): java.lang.String)
      .optionallyWith(
        entryPointArguments.map(value =>
          value.map { item =>
            EntryPointArgument.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.entryPointArguments)
      .optionallyWith(
        sparkSubmitParameters.map(value =>
          SparkSubmitParameters.unwrap(value): java.lang.String
        )
      )(_.sparkSubmitParameters)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.SparkSubmit.ReadOnly =
    zio.aws.emrserverless.model.SparkSubmit.wrap(buildAwsValue())
}
object SparkSubmit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.SparkSubmit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.SparkSubmit =
      zio.aws.emrserverless.model.SparkSubmit(
        entryPoint,
        entryPointArguments.map(value => value),
        sparkSubmitParameters.map(value => value)
      )
    def entryPoint: EntryPointPath
    def entryPointArguments: Optional[List[EntryPointArgument]]
    def sparkSubmitParameters: Optional[SparkSubmitParameters]
    def getEntryPoint: ZIO[Any, Nothing, EntryPointPath] =
      ZIO.succeed(entryPoint)
    def getEntryPointArguments: ZIO[Any, AwsError, List[EntryPointArgument]] =
      AwsError.unwrapOptionField("entryPointArguments", entryPointArguments)
    def getSparkSubmitParameters: ZIO[Any, AwsError, SparkSubmitParameters] =
      AwsError.unwrapOptionField("sparkSubmitParameters", sparkSubmitParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.SparkSubmit
  ) extends zio.aws.emrserverless.model.SparkSubmit.ReadOnly {
    override val entryPoint: EntryPointPath =
      zio.aws.emrserverless.model.primitives.EntryPointPath(impl.entryPoint())
    override val entryPointArguments: Optional[List[EntryPointArgument]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entryPointArguments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emrserverless.model.primitives.EntryPointArgument(item)
          }.toList
        )
    override val sparkSubmitParameters: Optional[SparkSubmitParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sparkSubmitParameters())
        .map(value =>
          zio.aws.emrserverless.model.primitives.SparkSubmitParameters(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.SparkSubmit
  ): zio.aws.emrserverless.model.SparkSubmit.ReadOnly = new Wrapper(impl)
}
