package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{DiskSize, MemorySize, CpuSize}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MaximumAllowedResources(
    cpu: CpuSize,
    memory: MemorySize,
    disk: Optional[DiskSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.MaximumAllowedResources = {
    import MaximumAllowedResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.MaximumAllowedResources
      .builder()
      .cpu(CpuSize.unwrap(cpu): java.lang.String)
      .memory(MemorySize.unwrap(memory): java.lang.String)
      .optionallyWith(
        disk.map(value => DiskSize.unwrap(value): java.lang.String)
      )(_.disk)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly =
    zio.aws.emrserverless.model.MaximumAllowedResources.wrap(buildAwsValue())
}
object MaximumAllowedResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.MaximumAllowedResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.MaximumAllowedResources =
      zio.aws.emrserverless.model
        .MaximumAllowedResources(cpu, memory, disk.map(value => value))
    def cpu: CpuSize
    def memory: MemorySize
    def disk: Optional[DiskSize]
    def getCpu: ZIO[Any, Nothing, CpuSize] = ZIO.succeed(cpu)
    def getMemory: ZIO[Any, Nothing, MemorySize] = ZIO.succeed(memory)
    def getDisk: ZIO[Any, AwsError, DiskSize] =
      AwsError.unwrapOptionField("disk", disk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.MaximumAllowedResources
  ) extends zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly {
    override val cpu: CpuSize =
      zio.aws.emrserverless.model.primitives.CpuSize(impl.cpu())
    override val memory: MemorySize =
      zio.aws.emrserverless.model.primitives.MemorySize(impl.memory())
    override val disk: Optional[DiskSize] = zio.aws.core.internal
      .optionalFromNullable(impl.disk())
      .map(value => zio.aws.emrserverless.model.primitives.DiskSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.MaximumAllowedResources
  ): zio.aws.emrserverless.model.MaximumAllowedResources.ReadOnly = new Wrapper(
    impl
  )
}
