package zio.aws.emrserverless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emrserverless.model.primitives.{
  ListApplicationsRequestMaxResultsInteger,
  NextToken
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListApplicationsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[ListApplicationsRequestMaxResultsInteger] =
      Optional.Absent,
    states: Optional[Iterable[zio.aws.emrserverless.model.ApplicationState]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.ListApplicationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListApplicationsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.ListApplicationsRequest.ReadOnly =
    zio.aws.emrserverless.model.ListApplicationsRequest.wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.ListApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.ListApplicationsRequest =
      zio.aws.emrserverless.model.ListApplicationsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        states.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[ListApplicationsRequestMaxResultsInteger]
    def states: Optional[List[zio.aws.emrserverless.model.ApplicationState]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListApplicationsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStates: ZIO[Any, AwsError, List[
      zio.aws.emrserverless.model.ApplicationState
    ]] = AwsError.unwrapOptionField("states", states)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.ListApplicationsRequest
  ) extends zio.aws.emrserverless.model.ListApplicationsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.emrserverless.model.primitives.NextToken(value))
    override val maxResults
        : Optional[ListApplicationsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.emrserverless.model.primitives
            .ListApplicationsRequestMaxResultsInteger(value)
        )
    override val states
        : Optional[List[zio.aws.emrserverless.model.ApplicationState]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.states())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emrserverless.model.ApplicationState.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.ListApplicationsRequest
  ): zio.aws.emrserverless.model.ListApplicationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
