package zio.aws.emrserverless.model
import zio.aws.emrserverless.model.primitives.{
  ApplicationArn,
  ApplicationName,
  ApplicationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    applicationId: ApplicationId,
    name: Optional[ApplicationName] = Optional.Absent,
    arn: ApplicationArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.CreateApplicationResponse
      .builder()
      .applicationId(ApplicationId.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .arn(ApplicationArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.emrserverless.model.CreateApplicationResponse.ReadOnly =
    zio.aws.emrserverless.model.CreateApplicationResponse.wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.CreateApplicationResponse =
      zio.aws.emrserverless.model
        .CreateApplicationResponse(applicationId, name.map(value => value), arn)
    def applicationId: ApplicationId
    def name: Optional[ApplicationName]
    def arn: ApplicationArn
    def getApplicationId: ZIO[Any, Nothing, ApplicationId] =
      ZIO.succeed(applicationId)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, Nothing, ApplicationArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.CreateApplicationResponse
  ) extends zio.aws.emrserverless.model.CreateApplicationResponse.ReadOnly {
    override val applicationId: ApplicationId =
      zio.aws.emrserverless.model.primitives.ApplicationId(impl.applicationId())
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.emrserverless.model.primitives.ApplicationName(value)
      )
    override val arn: ApplicationArn =
      zio.aws.emrserverless.model.primitives.ApplicationArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.CreateApplicationResponse
  ): zio.aws.emrserverless.model.CreateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
