package zio.aws.emrserverless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfigurationOverrides(
    applicationConfiguration: Optional[
      Iterable[zio.aws.emrserverless.model.Configuration]
    ] = Optional.Absent,
    monitoringConfiguration: Optional[
      zio.aws.emrserverless.model.MonitoringConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emrserverless.model.ConfigurationOverrides = {
    import ConfigurationOverrides.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emrserverless.model.ConfigurationOverrides
      .builder()
      .optionallyWith(
        applicationConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationConfiguration)
      .optionallyWith(
        monitoringConfiguration.map(value => value.buildAwsValue())
      )(_.monitoringConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.emrserverless.model.ConfigurationOverrides.ReadOnly =
    zio.aws.emrserverless.model.ConfigurationOverrides.wrap(buildAwsValue())
}
object ConfigurationOverrides {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emrserverless.model.ConfigurationOverrides
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emrserverless.model.ConfigurationOverrides =
      zio.aws.emrserverless.model.ConfigurationOverrides(
        applicationConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        monitoringConfiguration.map(value => value.asEditable)
      )
    def applicationConfiguration
        : Optional[List[zio.aws.emrserverless.model.Configuration.ReadOnly]]
    def monitoringConfiguration
        : Optional[zio.aws.emrserverless.model.MonitoringConfiguration.ReadOnly]
    def getApplicationConfiguration: ZIO[Any, AwsError, List[
      zio.aws.emrserverless.model.Configuration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "applicationConfiguration",
      applicationConfiguration
    )
    def getMonitoringConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.emrserverless.model.MonitoringConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfiguration",
      monitoringConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emrserverless.model.ConfigurationOverrides
  ) extends zio.aws.emrserverless.model.ConfigurationOverrides.ReadOnly {
    override val applicationConfiguration
        : Optional[List[zio.aws.emrserverless.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationConfiguration())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emrserverless.model.Configuration.wrap(item)
          }.toList
        )
    override val monitoringConfiguration: Optional[
      zio.aws.emrserverless.model.MonitoringConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringConfiguration())
      .map(value =>
        zio.aws.emrserverless.model.MonitoringConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emrserverless.model.ConfigurationOverrides
  ): zio.aws.emrserverless.model.ConfigurationOverrides.ReadOnly = new Wrapper(
    impl
  )
}
