package zio.aws.emr.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.WholeNumber
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SpotProvisioningSpecification(
    timeoutDurationMinutes: WholeNumber,
    timeoutAction: zio.aws.emr.model.SpotProvisioningTimeoutAction,
    blockDurationMinutes: Optional[WholeNumber] = Optional.Absent,
    allocationStrategy: Optional[
      zio.aws.emr.model.SpotProvisioningAllocationStrategy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SpotProvisioningSpecification = {
    import SpotProvisioningSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SpotProvisioningSpecification
      .builder()
      .timeoutDurationMinutes(
        WholeNumber.unwrap(timeoutDurationMinutes): Integer
      )
      .timeoutAction(timeoutAction.unwrap)
      .optionallyWith(
        blockDurationMinutes.map(value => WholeNumber.unwrap(value): Integer)
      )(_.blockDurationMinutes)
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SpotProvisioningSpecification.ReadOnly =
    zio.aws.emr.model.SpotProvisioningSpecification.wrap(buildAwsValue())
}
object SpotProvisioningSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SpotProvisioningSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SpotProvisioningSpecification =
      zio.aws.emr.model.SpotProvisioningSpecification(
        timeoutDurationMinutes,
        timeoutAction,
        blockDurationMinutes.map(value => value),
        allocationStrategy.map(value => value)
      )
    def timeoutDurationMinutes: WholeNumber
    def timeoutAction: zio.aws.emr.model.SpotProvisioningTimeoutAction
    def blockDurationMinutes: Optional[WholeNumber]
    def allocationStrategy
        : Optional[zio.aws.emr.model.SpotProvisioningAllocationStrategy]
    def getTimeoutDurationMinutes: ZIO[Any, Nothing, WholeNumber] =
      ZIO.succeed(timeoutDurationMinutes)
    def getTimeoutAction
        : ZIO[Any, Nothing, zio.aws.emr.model.SpotProvisioningTimeoutAction] =
      ZIO.succeed(timeoutAction)
    def getBlockDurationMinutes: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("blockDurationMinutes", blockDurationMinutes)
    def getAllocationStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.SpotProvisioningAllocationStrategy
    ] = AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SpotProvisioningSpecification
  ) extends zio.aws.emr.model.SpotProvisioningSpecification.ReadOnly {
    override val timeoutDurationMinutes: WholeNumber =
      zio.aws.emr.model.primitives.WholeNumber(impl.timeoutDurationMinutes())
    override val timeoutAction
        : zio.aws.emr.model.SpotProvisioningTimeoutAction =
      zio.aws.emr.model.SpotProvisioningTimeoutAction.wrap(impl.timeoutAction())
    override val blockDurationMinutes: Optional[WholeNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockDurationMinutes())
        .map(value => zio.aws.emr.model.primitives.WholeNumber(value))
    override val allocationStrategy
        : Optional[zio.aws.emr.model.SpotProvisioningAllocationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationStrategy())
        .map(value =>
          zio.aws.emr.model.SpotProvisioningAllocationStrategy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SpotProvisioningSpecification
  ): zio.aws.emr.model.SpotProvisioningSpecification.ReadOnly = new Wrapper(
    impl
  )
}
