package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Integer, XmlString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RunJobFlowRequest(
    name: XmlStringMaxLen256,
    logUri: Optional[XmlString] = Optional.Absent,
    logEncryptionKmsKeyId: Optional[XmlString] = Optional.Absent,
    additionalInfo: Optional[XmlString] = Optional.Absent,
    amiVersion: Optional[XmlStringMaxLen256] = Optional.Absent,
    releaseLabel: Optional[XmlStringMaxLen256] = Optional.Absent,
    instances: zio.aws.emr.model.JobFlowInstancesConfig,
    steps: Optional[Iterable[zio.aws.emr.model.StepConfig]] = Optional.Absent,
    bootstrapActions: Optional[
      Iterable[zio.aws.emr.model.BootstrapActionConfig]
    ] = Optional.Absent,
    supportedProducts: Optional[Iterable[XmlStringMaxLen256]] = Optional.Absent,
    newSupportedProducts: Optional[
      Iterable[zio.aws.emr.model.SupportedProductConfig]
    ] = Optional.Absent,
    applications: Optional[Iterable[zio.aws.emr.model.Application]] =
      Optional.Absent,
    configurations: Optional[Iterable[zio.aws.emr.model.Configuration]] =
      Optional.Absent,
    visibleToAllUsers: Optional[Boolean] = Optional.Absent,
    jobFlowRole: Optional[XmlString] = Optional.Absent,
    serviceRole: Optional[XmlString] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.emr.model.Tag]] = Optional.Absent,
    securityConfiguration: Optional[XmlString] = Optional.Absent,
    autoScalingRole: Optional[XmlString] = Optional.Absent,
    scaleDownBehavior: Optional[zio.aws.emr.model.ScaleDownBehavior] =
      Optional.Absent,
    customAmiId: Optional[XmlStringMaxLen256] = Optional.Absent,
    ebsRootVolumeSize: Optional[Integer] = Optional.Absent,
    repoUpgradeOnBoot: Optional[zio.aws.emr.model.RepoUpgradeOnBoot] =
      Optional.Absent,
    kerberosAttributes: Optional[zio.aws.emr.model.KerberosAttributes] =
      Optional.Absent,
    stepConcurrencyLevel: Optional[Integer] = Optional.Absent,
    managedScalingPolicy: Optional[zio.aws.emr.model.ManagedScalingPolicy] =
      Optional.Absent,
    placementGroupConfigs: Optional[
      Iterable[zio.aws.emr.model.PlacementGroupConfig]
    ] = Optional.Absent,
    autoTerminationPolicy: Optional[zio.aws.emr.model.AutoTerminationPolicy] =
      Optional.Absent,
    osReleaseLabel: Optional[XmlStringMaxLen256] = Optional.Absent,
    ebsRootVolumeIops: Optional[Integer] = Optional.Absent,
    ebsRootVolumeThroughput: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.RunJobFlowRequest = {
    import RunJobFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.RunJobFlowRequest
      .builder()
      .name(XmlStringMaxLen256.unwrap(name): java.lang.String)
      .optionallyWith(
        logUri.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        logEncryptionKmsKeyId.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.logEncryptionKmsKeyId)
      .optionallyWith(
        additionalInfo.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.additionalInfo)
      .optionallyWith(
        amiVersion.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.amiVersion)
      .optionallyWith(
        releaseLabel.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.releaseLabel)
      .instances(instances.buildAwsValue())
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .optionallyWith(
        bootstrapActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bootstrapActions)
      .optionallyWith(
        supportedProducts.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedProducts)
      .optionallyWith(
        newSupportedProducts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.newSupportedProducts)
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(visibleToAllUsers.map(value => value: java.lang.Boolean))(
        _.visibleToAllUsers
      )
      .optionallyWith(
        jobFlowRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.jobFlowRole)
      .optionallyWith(
        serviceRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        securityConfiguration.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.securityConfiguration)
      .optionallyWith(
        autoScalingRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.autoScalingRole)
      .optionallyWith(scaleDownBehavior.map(value => value.unwrap))(
        _.scaleDownBehavior
      )
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .optionallyWith(ebsRootVolumeSize.map(value => value: java.lang.Integer))(
        _.ebsRootVolumeSize
      )
      .optionallyWith(repoUpgradeOnBoot.map(value => value.unwrap))(
        _.repoUpgradeOnBoot
      )
      .optionallyWith(kerberosAttributes.map(value => value.buildAwsValue()))(
        _.kerberosAttributes
      )
      .optionallyWith(
        stepConcurrencyLevel.map(value => value: java.lang.Integer)
      )(_.stepConcurrencyLevel)
      .optionallyWith(managedScalingPolicy.map(value => value.buildAwsValue()))(
        _.managedScalingPolicy
      )
      .optionallyWith(
        placementGroupConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementGroupConfigs)
      .optionallyWith(
        autoTerminationPolicy.map(value => value.buildAwsValue())
      )(_.autoTerminationPolicy)
      .optionallyWith(
        osReleaseLabel.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.osReleaseLabel)
      .optionallyWith(ebsRootVolumeIops.map(value => value: java.lang.Integer))(
        _.ebsRootVolumeIops
      )
      .optionallyWith(
        ebsRootVolumeThroughput.map(value => value: java.lang.Integer)
      )(_.ebsRootVolumeThroughput)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.RunJobFlowRequest.ReadOnly =
    zio.aws.emr.model.RunJobFlowRequest.wrap(buildAwsValue())
}
object RunJobFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.RunJobFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.RunJobFlowRequest =
      zio.aws.emr.model.RunJobFlowRequest(
        name,
        logUri.map(value => value),
        logEncryptionKmsKeyId.map(value => value),
        additionalInfo.map(value => value),
        amiVersion.map(value => value),
        releaseLabel.map(value => value),
        instances.asEditable,
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        bootstrapActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedProducts.map(value => value),
        newSupportedProducts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        visibleToAllUsers.map(value => value),
        jobFlowRole.map(value => value),
        serviceRole.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityConfiguration.map(value => value),
        autoScalingRole.map(value => value),
        scaleDownBehavior.map(value => value),
        customAmiId.map(value => value),
        ebsRootVolumeSize.map(value => value),
        repoUpgradeOnBoot.map(value => value),
        kerberosAttributes.map(value => value.asEditable),
        stepConcurrencyLevel.map(value => value),
        managedScalingPolicy.map(value => value.asEditable),
        placementGroupConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoTerminationPolicy.map(value => value.asEditable),
        osReleaseLabel.map(value => value),
        ebsRootVolumeIops.map(value => value),
        ebsRootVolumeThroughput.map(value => value)
      )
    def name: XmlStringMaxLen256
    def logUri: Optional[XmlString]
    def logEncryptionKmsKeyId: Optional[XmlString]
    def additionalInfo: Optional[XmlString]
    def amiVersion: Optional[XmlStringMaxLen256]
    def releaseLabel: Optional[XmlStringMaxLen256]
    def instances: zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly
    def steps: Optional[List[zio.aws.emr.model.StepConfig.ReadOnly]]
    def bootstrapActions
        : Optional[List[zio.aws.emr.model.BootstrapActionConfig.ReadOnly]]
    def supportedProducts: Optional[List[XmlStringMaxLen256]]
    def newSupportedProducts
        : Optional[List[zio.aws.emr.model.SupportedProductConfig.ReadOnly]]
    def applications: Optional[List[zio.aws.emr.model.Application.ReadOnly]]
    def configurations: Optional[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def visibleToAllUsers: Optional[Boolean]
    def jobFlowRole: Optional[XmlString]
    def serviceRole: Optional[XmlString]
    def tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]]
    def securityConfiguration: Optional[XmlString]
    def autoScalingRole: Optional[XmlString]
    def scaleDownBehavior: Optional[zio.aws.emr.model.ScaleDownBehavior]
    def customAmiId: Optional[XmlStringMaxLen256]
    def ebsRootVolumeSize: Optional[Integer]
    def repoUpgradeOnBoot: Optional[zio.aws.emr.model.RepoUpgradeOnBoot]
    def kerberosAttributes
        : Optional[zio.aws.emr.model.KerberosAttributes.ReadOnly]
    def stepConcurrencyLevel: Optional[Integer]
    def managedScalingPolicy
        : Optional[zio.aws.emr.model.ManagedScalingPolicy.ReadOnly]
    def placementGroupConfigs
        : Optional[List[zio.aws.emr.model.PlacementGroupConfig.ReadOnly]]
    def autoTerminationPolicy
        : Optional[zio.aws.emr.model.AutoTerminationPolicy.ReadOnly]
    def osReleaseLabel: Optional[XmlStringMaxLen256]
    def ebsRootVolumeIops: Optional[Integer]
    def ebsRootVolumeThroughput: Optional[Integer]
    def getName: ZIO[Any, Nothing, XmlStringMaxLen256] = ZIO.succeed(name)
    def getLogUri: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getLogEncryptionKmsKeyId: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("logEncryptionKmsKeyId", logEncryptionKmsKeyId)
    def getAdditionalInfo: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getAmiVersion: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("amiVersion", amiVersion)
    def getReleaseLabel: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("releaseLabel", releaseLabel)
    def getInstances
        : ZIO[Any, Nothing, zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly] =
      ZIO.succeed(instances)
    def getSteps
        : ZIO[Any, AwsError, List[zio.aws.emr.model.StepConfig.ReadOnly]] =
      AwsError.unwrapOptionField("steps", steps)
    def getBootstrapActions: ZIO[Any, AwsError, List[
      zio.aws.emr.model.BootstrapActionConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("bootstrapActions", bootstrapActions)
    def getSupportedProducts: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("supportedProducts", supportedProducts)
    def getNewSupportedProducts: ZIO[Any, AwsError, List[
      zio.aws.emr.model.SupportedProductConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("newSupportedProducts", newSupportedProducts)
    def getApplications
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Application.ReadOnly]] =
      AwsError.unwrapOptionField("applications", applications)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getVisibleToAllUsers: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("visibleToAllUsers", visibleToAllUsers)
    def getJobFlowRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("jobFlowRole", jobFlowRole)
    def getServiceRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSecurityConfiguration: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("securityConfiguration", securityConfiguration)
    def getAutoScalingRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("autoScalingRole", autoScalingRole)
    def getScaleDownBehavior
        : ZIO[Any, AwsError, zio.aws.emr.model.ScaleDownBehavior] =
      AwsError.unwrapOptionField("scaleDownBehavior", scaleDownBehavior)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
    def getEbsRootVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ebsRootVolumeSize", ebsRootVolumeSize)
    def getRepoUpgradeOnBoot
        : ZIO[Any, AwsError, zio.aws.emr.model.RepoUpgradeOnBoot] =
      AwsError.unwrapOptionField("repoUpgradeOnBoot", repoUpgradeOnBoot)
    def getKerberosAttributes
        : ZIO[Any, AwsError, zio.aws.emr.model.KerberosAttributes.ReadOnly] =
      AwsError.unwrapOptionField("kerberosAttributes", kerberosAttributes)
    def getStepConcurrencyLevel: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stepConcurrencyLevel", stepConcurrencyLevel)
    def getManagedScalingPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.ManagedScalingPolicy.ReadOnly] =
      AwsError.unwrapOptionField("managedScalingPolicy", managedScalingPolicy)
    def getPlacementGroupConfigs: ZIO[Any, AwsError, List[
      zio.aws.emr.model.PlacementGroupConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementGroupConfigs", placementGroupConfigs)
    def getAutoTerminationPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.AutoTerminationPolicy.ReadOnly] =
      AwsError.unwrapOptionField("autoTerminationPolicy", autoTerminationPolicy)
    def getOsReleaseLabel: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("osReleaseLabel", osReleaseLabel)
    def getEbsRootVolumeIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ebsRootVolumeIops", ebsRootVolumeIops)
    def getEbsRootVolumeThroughput: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("ebsRootVolumeThroughput", ebsRootVolumeThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.RunJobFlowRequest
  ) extends zio.aws.emr.model.RunJobFlowRequest.ReadOnly {
    override val name: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.name())
    override val logUri: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.logUri())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val logEncryptionKmsKeyId: Optional[XmlString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logEncryptionKmsKeyId())
        .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val additionalInfo: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInfo())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val amiVersion: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amiVersion())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val releaseLabel: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.releaseLabel())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val instances: zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly =
      zio.aws.emr.model.JobFlowInstancesConfig.wrap(impl.instances())
    override val steps: Optional[List[zio.aws.emr.model.StepConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.steps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.StepConfig.wrap(item)
          }.toList
        )
    override val bootstrapActions
        : Optional[List[zio.aws.emr.model.BootstrapActionConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootstrapActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.BootstrapActionConfig.wrap(item)
          }.toList
        )
    override val supportedProducts: Optional[List[XmlStringMaxLen256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedProducts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
          }.toList
        )
    override val newSupportedProducts
        : Optional[List[zio.aws.emr.model.SupportedProductConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newSupportedProducts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.SupportedProductConfig.wrap(item)
          }.toList
        )
    override val applications
        : Optional[List[zio.aws.emr.model.Application.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Application.wrap(item)
          }.toList
        )
    override val configurations
        : Optional[List[zio.aws.emr.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Configuration.wrap(item)
          }.toList
        )
    override val visibleToAllUsers: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.visibleToAllUsers())
      .map(value => value: Boolean)
    override val jobFlowRole: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.jobFlowRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val serviceRole: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Tag.wrap(item)
          }.toList
        )
    override val securityConfiguration: Optional[XmlString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityConfiguration())
        .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val autoScalingRole: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val scaleDownBehavior
        : Optional[zio.aws.emr.model.ScaleDownBehavior] = zio.aws.core.internal
      .optionalFromNullable(impl.scaleDownBehavior())
      .map(value => zio.aws.emr.model.ScaleDownBehavior.wrap(value))
    override val customAmiId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAmiId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val ebsRootVolumeSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsRootVolumeSize())
      .map(value => value: Integer)
    override val repoUpgradeOnBoot
        : Optional[zio.aws.emr.model.RepoUpgradeOnBoot] = zio.aws.core.internal
      .optionalFromNullable(impl.repoUpgradeOnBoot())
      .map(value => zio.aws.emr.model.RepoUpgradeOnBoot.wrap(value))
    override val kerberosAttributes
        : Optional[zio.aws.emr.model.KerberosAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosAttributes())
        .map(value => zio.aws.emr.model.KerberosAttributes.wrap(value))
    override val stepConcurrencyLevel: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.stepConcurrencyLevel())
      .map(value => value: Integer)
    override val managedScalingPolicy
        : Optional[zio.aws.emr.model.ManagedScalingPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedScalingPolicy())
        .map(value => zio.aws.emr.model.ManagedScalingPolicy.wrap(value))
    override val placementGroupConfigs
        : Optional[List[zio.aws.emr.model.PlacementGroupConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementGroupConfigs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.PlacementGroupConfig.wrap(item)
          }.toList
        )
    override val autoTerminationPolicy
        : Optional[zio.aws.emr.model.AutoTerminationPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTerminationPolicy())
        .map(value => zio.aws.emr.model.AutoTerminationPolicy.wrap(value))
    override val osReleaseLabel: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.osReleaseLabel())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val ebsRootVolumeIops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsRootVolumeIops())
      .map(value => value: Integer)
    override val ebsRootVolumeThroughput: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsRootVolumeThroughput())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.RunJobFlowRequest
  ): zio.aws.emr.model.RunJobFlowRequest.ReadOnly = new Wrapper(impl)
}
