package zio.aws.emr.model
import zio.aws.emr.model.primitives.{UriString, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputNotebookS3LocationFromInput(
    bucket: Optional[XmlStringMaxLen256] = Optional.Absent,
    key: Optional[UriString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.OutputNotebookS3LocationFromInput = {
    import OutputNotebookS3LocationFromInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.OutputNotebookS3LocationFromInput
      .builder()
      .optionallyWith(
        bucket.map(value => XmlStringMaxLen256.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => UriString.unwrap(value): java.lang.String)
      )(_.key)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.OutputNotebookS3LocationFromInput.ReadOnly =
    zio.aws.emr.model.OutputNotebookS3LocationFromInput.wrap(buildAwsValue())
}
object OutputNotebookS3LocationFromInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.OutputNotebookS3LocationFromInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.OutputNotebookS3LocationFromInput =
      zio.aws.emr.model.OutputNotebookS3LocationFromInput(
        bucket.map(value => value),
        key.map(value => value)
      )
    def bucket: Optional[XmlStringMaxLen256]
    def key: Optional[UriString]
    def getBucket: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, UriString] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.OutputNotebookS3LocationFromInput
  ) extends zio.aws.emr.model.OutputNotebookS3LocationFromInput.ReadOnly {
    override val bucket: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val key: Optional[UriString] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.emr.model.primitives.UriString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.OutputNotebookS3LocationFromInput
  ): zio.aws.emr.model.OutputNotebookS3LocationFromInput.ReadOnly = new Wrapper(
    impl
  )
}
