package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OnDemandProvisioningSpecification(
    allocationStrategy: zio.aws.emr.model.OnDemandProvisioningAllocationStrategy,
    capacityReservationOptions: Optional[
      zio.aws.emr.model.OnDemandCapacityReservationOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.OnDemandProvisioningSpecification = {
    import OnDemandProvisioningSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.OnDemandProvisioningSpecification
      .builder()
      .allocationStrategy(allocationStrategy.unwrap)
      .optionallyWith(
        capacityReservationOptions.map(value => value.buildAwsValue())
      )(_.capacityReservationOptions)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.OnDemandProvisioningSpecification.ReadOnly =
    zio.aws.emr.model.OnDemandProvisioningSpecification.wrap(buildAwsValue())
}
object OnDemandProvisioningSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.OnDemandProvisioningSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.OnDemandProvisioningSpecification =
      zio.aws.emr.model.OnDemandProvisioningSpecification(
        allocationStrategy,
        capacityReservationOptions.map(value => value.asEditable)
      )
    def allocationStrategy
        : zio.aws.emr.model.OnDemandProvisioningAllocationStrategy
    def capacityReservationOptions: Optional[
      zio.aws.emr.model.OnDemandCapacityReservationOptions.ReadOnly
    ]
    def getAllocationStrategy: ZIO[
      Any,
      Nothing,
      zio.aws.emr.model.OnDemandProvisioningAllocationStrategy
    ] = ZIO.succeed(allocationStrategy)
    def getCapacityReservationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.OnDemandCapacityReservationOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationOptions",
      capacityReservationOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.OnDemandProvisioningSpecification
  ) extends zio.aws.emr.model.OnDemandProvisioningSpecification.ReadOnly {
    override val allocationStrategy
        : zio.aws.emr.model.OnDemandProvisioningAllocationStrategy =
      zio.aws.emr.model.OnDemandProvisioningAllocationStrategy
        .wrap(impl.allocationStrategy())
    override val capacityReservationOptions: Optional[
      zio.aws.emr.model.OnDemandCapacityReservationOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationOptions())
      .map(value =>
        zio.aws.emr.model.OnDemandCapacityReservationOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.OnDemandProvisioningSpecification
  ): zio.aws.emr.model.OnDemandProvisioningSpecification.ReadOnly = new Wrapper(
    impl
  )
}
