package zio.aws.emr.model
import zio.aws.emr.model.primitives.ClusterId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyInstanceFleetRequest(
    clusterId: ClusterId,
    instanceFleet: zio.aws.emr.model.InstanceFleetModifyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ModifyInstanceFleetRequest = {
    import ModifyInstanceFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ModifyInstanceFleetRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .instanceFleet(instanceFleet.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ModifyInstanceFleetRequest.ReadOnly =
    zio.aws.emr.model.ModifyInstanceFleetRequest.wrap(buildAwsValue())
}
object ModifyInstanceFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ModifyInstanceFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ModifyInstanceFleetRequest =
      zio.aws.emr.model
        .ModifyInstanceFleetRequest(clusterId, instanceFleet.asEditable)
    def clusterId: ClusterId
    def instanceFleet: zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getInstanceFleet: ZIO[
      Any,
      Nothing,
      zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly
    ] = ZIO.succeed(instanceFleet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ModifyInstanceFleetRequest
  ) extends zio.aws.emr.model.ModifyInstanceFleetRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val instanceFleet
        : zio.aws.emr.model.InstanceFleetModifyConfig.ReadOnly =
      zio.aws.emr.model.InstanceFleetModifyConfig.wrap(impl.instanceFleet())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ModifyInstanceFleetRequest
  ): zio.aws.emr.model.ModifyInstanceFleetRequest.ReadOnly = new Wrapper(impl)
}
