package zio.aws.emr.model
import zio.aws.emr.model.primitives.{Marker, ClusterId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInstanceFleetsRequest(
    clusterId: ClusterId,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest = {
    import ListInstanceFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListInstanceFleetsRequest.ReadOnly =
    zio.aws.emr.model.ListInstanceFleetsRequest.wrap(buildAwsValue())
}
object ListInstanceFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListInstanceFleetsRequest =
      zio.aws.emr.model
        .ListInstanceFleetsRequest(clusterId, marker.map(value => value))
    def clusterId: ClusterId
    def marker: Optional[Marker]
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest
  ) extends zio.aws.emr.model.ListInstanceFleetsRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest
  ): zio.aws.emr.model.ListInstanceFleetsRequest.ReadOnly = new Wrapper(impl)
}
