package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListClustersResponse(
    clusters: Optional[Iterable[zio.aws.emr.model.ClusterSummary]] =
      Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListClustersResponse = {
    import ListClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListClustersResponse
      .builder()
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListClustersResponse.ReadOnly =
    zio.aws.emr.model.ListClustersResponse.wrap(buildAwsValue())
}
object ListClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListClustersResponse =
      zio.aws.emr.model.ListClustersResponse(
        clusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def clusters: Optional[List[zio.aws.emr.model.ClusterSummary.ReadOnly]]
    def marker: Optional[Marker]
    def getClusters
        : ZIO[Any, AwsError, List[zio.aws.emr.model.ClusterSummary.ReadOnly]] =
      AwsError.unwrapOptionField("clusters", clusters)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListClustersResponse
  ) extends zio.aws.emr.model.ListClustersResponse.ReadOnly {
    override val clusters
        : Optional[List[zio.aws.emr.model.ClusterSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.ClusterSummary.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListClustersResponse
  ): zio.aws.emr.model.ListClustersResponse.ReadOnly = new Wrapper(impl)
}
