package zio.aws.emr.model
import zio.aws.emr.model.primitives.{
  XmlStringMaxLen256,
  ArnType,
  XmlString,
  Integer,
  OptionalArnType,
  ClusterId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Cluster(
    id: Optional[ClusterId] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.emr.model.ClusterStatus] = Optional.Absent,
    ec2InstanceAttributes: Optional[zio.aws.emr.model.Ec2InstanceAttributes] =
      Optional.Absent,
    instanceCollectionType: Optional[zio.aws.emr.model.InstanceCollectionType] =
      Optional.Absent,
    logUri: Optional[String] = Optional.Absent,
    logEncryptionKmsKeyId: Optional[String] = Optional.Absent,
    requestedAmiVersion: Optional[String] = Optional.Absent,
    runningAmiVersion: Optional[String] = Optional.Absent,
    releaseLabel: Optional[String] = Optional.Absent,
    autoTerminate: Optional[Boolean] = Optional.Absent,
    terminationProtected: Optional[Boolean] = Optional.Absent,
    visibleToAllUsers: Optional[Boolean] = Optional.Absent,
    applications: Optional[Iterable[zio.aws.emr.model.Application]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.emr.model.Tag]] = Optional.Absent,
    serviceRole: Optional[String] = Optional.Absent,
    normalizedInstanceHours: Optional[Integer] = Optional.Absent,
    masterPublicDnsName: Optional[String] = Optional.Absent,
    configurations: Optional[Iterable[zio.aws.emr.model.Configuration]] =
      Optional.Absent,
    securityConfiguration: Optional[XmlString] = Optional.Absent,
    autoScalingRole: Optional[XmlString] = Optional.Absent,
    scaleDownBehavior: Optional[zio.aws.emr.model.ScaleDownBehavior] =
      Optional.Absent,
    customAmiId: Optional[XmlStringMaxLen256] = Optional.Absent,
    ebsRootVolumeSize: Optional[Integer] = Optional.Absent,
    repoUpgradeOnBoot: Optional[zio.aws.emr.model.RepoUpgradeOnBoot] =
      Optional.Absent,
    kerberosAttributes: Optional[zio.aws.emr.model.KerberosAttributes] =
      Optional.Absent,
    clusterArn: Optional[ArnType] = Optional.Absent,
    outpostArn: Optional[OptionalArnType] = Optional.Absent,
    stepConcurrencyLevel: Optional[Integer] = Optional.Absent,
    placementGroups: Optional[
      Iterable[zio.aws.emr.model.PlacementGroupConfig]
    ] = Optional.Absent,
    osReleaseLabel: Optional[String] = Optional.Absent,
    ebsRootVolumeIops: Optional[Integer] = Optional.Absent,
    ebsRootVolumeThroughput: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Cluster = {
    import Cluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Cluster
      .builder()
      .optionallyWith(
        id.map(value => ClusterId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        ec2InstanceAttributes.map(value => value.buildAwsValue())
      )(_.ec2InstanceAttributes)
      .optionallyWith(instanceCollectionType.map(value => value.unwrap))(
        _.instanceCollectionType
      )
      .optionallyWith(logUri.map(value => value: java.lang.String))(_.logUri)
      .optionallyWith(
        logEncryptionKmsKeyId.map(value => value: java.lang.String)
      )(_.logEncryptionKmsKeyId)
      .optionallyWith(
        requestedAmiVersion.map(value => value: java.lang.String)
      )(_.requestedAmiVersion)
      .optionallyWith(runningAmiVersion.map(value => value: java.lang.String))(
        _.runningAmiVersion
      )
      .optionallyWith(releaseLabel.map(value => value: java.lang.String))(
        _.releaseLabel
      )
      .optionallyWith(autoTerminate.map(value => value: java.lang.Boolean))(
        _.autoTerminate
      )
      .optionallyWith(
        terminationProtected.map(value => value: java.lang.Boolean)
      )(_.terminationProtected)
      .optionallyWith(visibleToAllUsers.map(value => value: java.lang.Boolean))(
        _.visibleToAllUsers
      )
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .optionallyWith(
        normalizedInstanceHours.map(value => value: java.lang.Integer)
      )(_.normalizedInstanceHours)
      .optionallyWith(
        masterPublicDnsName.map(value => value: java.lang.String)
      )(_.masterPublicDnsName)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(
        securityConfiguration.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.securityConfiguration)
      .optionallyWith(
        autoScalingRole.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.autoScalingRole)
      .optionallyWith(scaleDownBehavior.map(value => value.unwrap))(
        _.scaleDownBehavior
      )
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .optionallyWith(ebsRootVolumeSize.map(value => value: java.lang.Integer))(
        _.ebsRootVolumeSize
      )
      .optionallyWith(repoUpgradeOnBoot.map(value => value.unwrap))(
        _.repoUpgradeOnBoot
      )
      .optionallyWith(kerberosAttributes.map(value => value.buildAwsValue()))(
        _.kerberosAttributes
      )
      .optionallyWith(
        clusterArn.map(value => ArnType.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        outpostArn.map(value => OptionalArnType.unwrap(value): java.lang.String)
      )(_.outpostArn)
      .optionallyWith(
        stepConcurrencyLevel.map(value => value: java.lang.Integer)
      )(_.stepConcurrencyLevel)
      .optionallyWith(
        placementGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementGroups)
      .optionallyWith(osReleaseLabel.map(value => value: java.lang.String))(
        _.osReleaseLabel
      )
      .optionallyWith(ebsRootVolumeIops.map(value => value: java.lang.Integer))(
        _.ebsRootVolumeIops
      )
      .optionallyWith(
        ebsRootVolumeThroughput.map(value => value: java.lang.Integer)
      )(_.ebsRootVolumeThroughput)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Cluster.ReadOnly =
    zio.aws.emr.model.Cluster.wrap(buildAwsValue())
}
object Cluster {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Cluster] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Cluster = zio.aws.emr.model.Cluster(
      id.map(value => value),
      name.map(value => value),
      status.map(value => value.asEditable),
      ec2InstanceAttributes.map(value => value.asEditable),
      instanceCollectionType.map(value => value),
      logUri.map(value => value),
      logEncryptionKmsKeyId.map(value => value),
      requestedAmiVersion.map(value => value),
      runningAmiVersion.map(value => value),
      releaseLabel.map(value => value),
      autoTerminate.map(value => value),
      terminationProtected.map(value => value),
      visibleToAllUsers.map(value => value),
      applications.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      serviceRole.map(value => value),
      normalizedInstanceHours.map(value => value),
      masterPublicDnsName.map(value => value),
      configurations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      securityConfiguration.map(value => value),
      autoScalingRole.map(value => value),
      scaleDownBehavior.map(value => value),
      customAmiId.map(value => value),
      ebsRootVolumeSize.map(value => value),
      repoUpgradeOnBoot.map(value => value),
      kerberosAttributes.map(value => value.asEditable),
      clusterArn.map(value => value),
      outpostArn.map(value => value),
      stepConcurrencyLevel.map(value => value),
      placementGroups.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      osReleaseLabel.map(value => value),
      ebsRootVolumeIops.map(value => value),
      ebsRootVolumeThroughput.map(value => value)
    )
    def id: Optional[ClusterId]
    def name: Optional[String]
    def status: Optional[zio.aws.emr.model.ClusterStatus.ReadOnly]
    def ec2InstanceAttributes
        : Optional[zio.aws.emr.model.Ec2InstanceAttributes.ReadOnly]
    def instanceCollectionType
        : Optional[zio.aws.emr.model.InstanceCollectionType]
    def logUri: Optional[String]
    def logEncryptionKmsKeyId: Optional[String]
    def requestedAmiVersion: Optional[String]
    def runningAmiVersion: Optional[String]
    def releaseLabel: Optional[String]
    def autoTerminate: Optional[Boolean]
    def terminationProtected: Optional[Boolean]
    def visibleToAllUsers: Optional[Boolean]
    def applications: Optional[List[zio.aws.emr.model.Application.ReadOnly]]
    def tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]]
    def serviceRole: Optional[String]
    def normalizedInstanceHours: Optional[Integer]
    def masterPublicDnsName: Optional[String]
    def configurations: Optional[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def securityConfiguration: Optional[XmlString]
    def autoScalingRole: Optional[XmlString]
    def scaleDownBehavior: Optional[zio.aws.emr.model.ScaleDownBehavior]
    def customAmiId: Optional[XmlStringMaxLen256]
    def ebsRootVolumeSize: Optional[Integer]
    def repoUpgradeOnBoot: Optional[zio.aws.emr.model.RepoUpgradeOnBoot]
    def kerberosAttributes
        : Optional[zio.aws.emr.model.KerberosAttributes.ReadOnly]
    def clusterArn: Optional[ArnType]
    def outpostArn: Optional[OptionalArnType]
    def stepConcurrencyLevel: Optional[Integer]
    def placementGroups
        : Optional[List[zio.aws.emr.model.PlacementGroupConfig.ReadOnly]]
    def osReleaseLabel: Optional[String]
    def ebsRootVolumeIops: Optional[Integer]
    def ebsRootVolumeThroughput: Optional[Integer]
    def getId: ZIO[Any, AwsError, ClusterId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.ClusterStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getEc2InstanceAttributes
        : ZIO[Any, AwsError, zio.aws.emr.model.Ec2InstanceAttributes.ReadOnly] =
      AwsError.unwrapOptionField("ec2InstanceAttributes", ec2InstanceAttributes)
    def getInstanceCollectionType
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceCollectionType] =
      AwsError.unwrapOptionField(
        "instanceCollectionType",
        instanceCollectionType
      )
    def getLogUri: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getLogEncryptionKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logEncryptionKmsKeyId", logEncryptionKmsKeyId)
    def getRequestedAmiVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestedAmiVersion", requestedAmiVersion)
    def getRunningAmiVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runningAmiVersion", runningAmiVersion)
    def getReleaseLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("releaseLabel", releaseLabel)
    def getAutoTerminate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoTerminate", autoTerminate)
    def getTerminationProtected: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("terminationProtected", terminationProtected)
    def getVisibleToAllUsers: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("visibleToAllUsers", visibleToAllUsers)
    def getApplications
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Application.ReadOnly]] =
      AwsError.unwrapOptionField("applications", applications)
    def getTags: ZIO[Any, AwsError, List[zio.aws.emr.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getServiceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getNormalizedInstanceHours: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("normalizedInstanceHours", normalizedInstanceHours)
    def getMasterPublicDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterPublicDnsName", masterPublicDnsName)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getSecurityConfiguration: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("securityConfiguration", securityConfiguration)
    def getAutoScalingRole: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("autoScalingRole", autoScalingRole)
    def getScaleDownBehavior
        : ZIO[Any, AwsError, zio.aws.emr.model.ScaleDownBehavior] =
      AwsError.unwrapOptionField("scaleDownBehavior", scaleDownBehavior)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
    def getEbsRootVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ebsRootVolumeSize", ebsRootVolumeSize)
    def getRepoUpgradeOnBoot
        : ZIO[Any, AwsError, zio.aws.emr.model.RepoUpgradeOnBoot] =
      AwsError.unwrapOptionField("repoUpgradeOnBoot", repoUpgradeOnBoot)
    def getKerberosAttributes
        : ZIO[Any, AwsError, zio.aws.emr.model.KerberosAttributes.ReadOnly] =
      AwsError.unwrapOptionField("kerberosAttributes", kerberosAttributes)
    def getClusterArn: ZIO[Any, AwsError, ArnType] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getOutpostArn: ZIO[Any, AwsError, OptionalArnType] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getStepConcurrencyLevel: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("stepConcurrencyLevel", stepConcurrencyLevel)
    def getPlacementGroups: ZIO[Any, AwsError, List[
      zio.aws.emr.model.PlacementGroupConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("placementGroups", placementGroups)
    def getOsReleaseLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("osReleaseLabel", osReleaseLabel)
    def getEbsRootVolumeIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ebsRootVolumeIops", ebsRootVolumeIops)
    def getEbsRootVolumeThroughput: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("ebsRootVolumeThroughput", ebsRootVolumeThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Cluster
  ) extends zio.aws.emr.model.Cluster.ReadOnly {
    override val id: Optional[ClusterId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.emr.model.primitives.ClusterId(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[zio.aws.emr.model.ClusterStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.ClusterStatus.wrap(value))
    override val ec2InstanceAttributes
        : Optional[zio.aws.emr.model.Ec2InstanceAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceAttributes())
        .map(value => zio.aws.emr.model.Ec2InstanceAttributes.wrap(value))
    override val instanceCollectionType
        : Optional[zio.aws.emr.model.InstanceCollectionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceCollectionType())
        .map(value => zio.aws.emr.model.InstanceCollectionType.wrap(value))
    override val logUri: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logUri())
      .map(value => value: String)
    override val logEncryptionKmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logEncryptionKmsKeyId())
      .map(value => value: String)
    override val requestedAmiVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedAmiVersion())
      .map(value => value: String)
    override val runningAmiVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.runningAmiVersion())
      .map(value => value: String)
    override val releaseLabel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseLabel())
      .map(value => value: String)
    override val autoTerminate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoTerminate())
      .map(value => value: Boolean)
    override val terminationProtected: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.terminationProtected())
      .map(value => value: Boolean)
    override val visibleToAllUsers: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.visibleToAllUsers())
      .map(value => value: Boolean)
    override val applications
        : Optional[List[zio.aws.emr.model.Application.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Application.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.emr.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Tag.wrap(item)
          }.toList
        )
    override val serviceRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => value: String)
    override val normalizedInstanceHours: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.normalizedInstanceHours())
        .map(value => value: Integer)
    override val masterPublicDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterPublicDnsName())
      .map(value => value: String)
    override val configurations
        : Optional[List[zio.aws.emr.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Configuration.wrap(item)
          }.toList
        )
    override val securityConfiguration: Optional[XmlString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityConfiguration())
        .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val autoScalingRole: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.autoScalingRole())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val scaleDownBehavior
        : Optional[zio.aws.emr.model.ScaleDownBehavior] = zio.aws.core.internal
      .optionalFromNullable(impl.scaleDownBehavior())
      .map(value => zio.aws.emr.model.ScaleDownBehavior.wrap(value))
    override val customAmiId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAmiId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val ebsRootVolumeSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsRootVolumeSize())
      .map(value => value: Integer)
    override val repoUpgradeOnBoot
        : Optional[zio.aws.emr.model.RepoUpgradeOnBoot] = zio.aws.core.internal
      .optionalFromNullable(impl.repoUpgradeOnBoot())
      .map(value => zio.aws.emr.model.RepoUpgradeOnBoot.wrap(value))
    override val kerberosAttributes
        : Optional[zio.aws.emr.model.KerberosAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosAttributes())
        .map(value => zio.aws.emr.model.KerberosAttributes.wrap(value))
    override val clusterArn: Optional[ArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => zio.aws.emr.model.primitives.ArnType(value))
    override val outpostArn: Optional[OptionalArnType] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => zio.aws.emr.model.primitives.OptionalArnType(value))
    override val stepConcurrencyLevel: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.stepConcurrencyLevel())
      .map(value => value: Integer)
    override val placementGroups
        : Optional[List[zio.aws.emr.model.PlacementGroupConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.PlacementGroupConfig.wrap(item)
          }.toList
        )
    override val osReleaseLabel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.osReleaseLabel())
      .map(value => value: String)
    override val ebsRootVolumeIops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsRootVolumeIops())
      .map(value => value: Integer)
    override val ebsRootVolumeThroughput: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsRootVolumeThroughput())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Cluster
  ): zio.aws.emr.model.Cluster.ReadOnly = new Wrapper(impl)
}
