package zio.aws.emr.model
import java.lang.Integer
import zio.aws.emr.model.primitives.WholeNumber
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SpotResizingSpecification(
    timeoutDurationMinutes: WholeNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.SpotResizingSpecification = {
    import SpotResizingSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.SpotResizingSpecification
      .builder()
      .timeoutDurationMinutes(
        WholeNumber.unwrap(timeoutDurationMinutes): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.SpotResizingSpecification.ReadOnly =
    zio.aws.emr.model.SpotResizingSpecification.wrap(buildAwsValue())
}
object SpotResizingSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.SpotResizingSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.SpotResizingSpecification =
      zio.aws.emr.model.SpotResizingSpecification(timeoutDurationMinutes)
    def timeoutDurationMinutes: WholeNumber
    def getTimeoutDurationMinutes: ZIO[Any, Nothing, WholeNumber] =
      ZIO.succeed(timeoutDurationMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.SpotResizingSpecification
  ) extends zio.aws.emr.model.SpotResizingSpecification.ReadOnly {
    override val timeoutDurationMinutes: WholeNumber =
      zio.aws.emr.model.primitives.WholeNumber(impl.timeoutDurationMinutes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.SpotResizingSpecification
  ): zio.aws.emr.model.SpotResizingSpecification.ReadOnly = new Wrapper(impl)
}
