package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.Date
import scala.jdk.CollectionConverters._
final case class GetClusterSessionCredentialsResponse(
    credentials: Optional[zio.aws.emr.model.Credentials] = Optional.Absent,
    expiresAt: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsResponse = {
    import GetClusterSessionCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .optionallyWith(expiresAt.map(value => Date.unwrap(value): Instant))(
        _.expiresAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.GetClusterSessionCredentialsResponse.ReadOnly =
    zio.aws.emr.model.GetClusterSessionCredentialsResponse.wrap(buildAwsValue())
}
object GetClusterSessionCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.GetClusterSessionCredentialsResponse =
      zio.aws.emr.model.GetClusterSessionCredentialsResponse(
        credentials.map(value => value.asEditable),
        expiresAt.map(value => value)
      )
    def credentials: Optional[zio.aws.emr.model.Credentials.ReadOnly]
    def expiresAt: Optional[Date]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.emr.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getExpiresAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("expiresAt", expiresAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsResponse
  ) extends zio.aws.emr.model.GetClusterSessionCredentialsResponse.ReadOnly {
    override val credentials: Optional[zio.aws.emr.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.emr.model.Credentials.wrap(value))
    override val expiresAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresAt())
      .map(value => zio.aws.emr.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.GetClusterSessionCredentialsResponse
  ): zio.aws.emr.model.GetClusterSessionCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
