package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Command(
    name: Optional[String] = Optional.Absent,
    scriptPath: Optional[String] = Optional.Absent,
    args: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.Command = {
    import Command.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.Command
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(scriptPath.map(value => value: java.lang.String))(
        _.scriptPath
      )
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.Command.ReadOnly =
    zio.aws.emr.model.Command.wrap(buildAwsValue())
}
object Command {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.Command] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.Command = zio.aws.emr.model.Command(
      name.map(value => value),
      scriptPath.map(value => value),
      args.map(value => value)
    )
    def name: Optional[String]
    def scriptPath: Optional[String]
    def args: Optional[List[String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getScriptPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scriptPath", scriptPath)
    def getArgs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("args", args)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.Command
  ) extends zio.aws.emr.model.Command.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val scriptPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptPath())
      .map(value => value: String)
    override val args: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.args())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.Command
  ): zio.aws.emr.model.Command.ReadOnly = new Wrapper(impl)
}
