package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStepsResponse(
    steps: Optional[Iterable[zio.aws.emr.model.StepSummary]] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListStepsResponse = {
    import ListStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListStepsResponse
      .builder()
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListStepsResponse.ReadOnly =
    zio.aws.emr.model.ListStepsResponse.wrap(buildAwsValue())
}
object ListStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListStepsResponse =
      zio.aws.emr.model.ListStepsResponse(
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def steps: Optional[List[zio.aws.emr.model.StepSummary.ReadOnly]]
    def marker: Optional[Marker]
    def getSteps
        : ZIO[Any, AwsError, List[zio.aws.emr.model.StepSummary.ReadOnly]] =
      AwsError.unwrapOptionField("steps", steps)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListStepsResponse
  ) extends zio.aws.emr.model.ListStepsResponse.ReadOnly {
    override val steps: Optional[List[zio.aws.emr.model.StepSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.steps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.StepSummary.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListStepsResponse
  ): zio.aws.emr.model.ListStepsResponse.ReadOnly = new Wrapper(impl)
}
