package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HadoopJarStepConfig(
    properties: Optional[Iterable[zio.aws.emr.model.KeyValue]] =
      Optional.Absent,
    jar: XmlString,
    mainClass: Optional[XmlString] = Optional.Absent,
    args: Optional[Iterable[XmlString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.HadoopJarStepConfig = {
    import HadoopJarStepConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.HadoopJarStepConfig
      .builder()
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .jar(XmlString.unwrap(jar): java.lang.String)
      .optionallyWith(
        mainClass.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.mainClass)
      .optionallyWith(
        args.map(value =>
          value.map { item =>
            XmlString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.args)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.HadoopJarStepConfig.ReadOnly =
    zio.aws.emr.model.HadoopJarStepConfig.wrap(buildAwsValue())
}
object HadoopJarStepConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.HadoopJarStepConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.HadoopJarStepConfig =
      zio.aws.emr.model.HadoopJarStepConfig(
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        jar,
        mainClass.map(value => value),
        args.map(value => value)
      )
    def properties: Optional[List[zio.aws.emr.model.KeyValue.ReadOnly]]
    def jar: XmlString
    def mainClass: Optional[XmlString]
    def args: Optional[List[XmlString]]
    def getProperties
        : ZIO[Any, AwsError, List[zio.aws.emr.model.KeyValue.ReadOnly]] =
      AwsError.unwrapOptionField("properties", properties)
    def getJar: ZIO[Any, Nothing, XmlString] = ZIO.succeed(jar)
    def getMainClass: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("mainClass", mainClass)
    def getArgs: ZIO[Any, AwsError, List[XmlString]] =
      AwsError.unwrapOptionField("args", args)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.HadoopJarStepConfig
  ) extends zio.aws.emr.model.HadoopJarStepConfig.ReadOnly {
    override val properties
        : Optional[List[zio.aws.emr.model.KeyValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.KeyValue.wrap(item)
          }.toList
        )
    override val jar: XmlString =
      zio.aws.emr.model.primitives.XmlString(impl.jar())
    override val mainClass: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.mainClass())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
    override val args: Optional[List[XmlString]] = zio.aws.core.internal
      .optionalFromNullable(impl.args())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.HadoopJarStepConfig
  ): zio.aws.emr.model.HadoopJarStepConfig.ReadOnly = new Wrapper(impl)
}
