package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ErrorDetail(
    errorCode: Optional[String] = Optional.Absent,
    errorData: Optional[Iterable[Map[String, String]]] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.emr.model.ErrorDetail = {
    import ErrorDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ErrorDetail
      .builder()
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(
        errorData.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (key: java.lang.String) -> (value: java.lang.String)
              })
              .asJava
          }.asJavaCollection
        )
      )(_.errorData)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ErrorDetail.ReadOnly =
    zio.aws.emr.model.ErrorDetail.wrap(buildAwsValue())
}
object ErrorDetail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.ErrorDetail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ErrorDetail =
      zio.aws.emr.model.ErrorDetail(
        errorCode.map(value => value),
        errorData.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Optional[String]
    def errorData: Optional[List[Map[String, String]]]
    def errorMessage: Optional[String]
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorData: ZIO[Any, AwsError, List[Map[String, String]]] =
      AwsError.unwrapOptionField("errorData", errorData)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ErrorDetail
  ) extends zio.aws.emr.model.ErrorDetail.ReadOnly {
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorData: Optional[List[Map[String, String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorData())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                (key: String) -> (value: String)
              })
              .toMap
          }.toList
        )
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ErrorDetail
  ): zio.aws.emr.model.ErrorDetail.ReadOnly = new Wrapper(impl)
}
