package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EbsBlockDevice(
    volumeSpecification: Optional[zio.aws.emr.model.VolumeSpecification] =
      Optional.Absent,
    device: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.EbsBlockDevice = {
    import EbsBlockDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.EbsBlockDevice
      .builder()
      .optionallyWith(volumeSpecification.map(value => value.buildAwsValue()))(
        _.volumeSpecification
      )
      .optionallyWith(device.map(value => value: java.lang.String))(_.device)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.EbsBlockDevice.ReadOnly =
    zio.aws.emr.model.EbsBlockDevice.wrap(buildAwsValue())
}
object EbsBlockDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.EbsBlockDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.EbsBlockDevice =
      zio.aws.emr.model.EbsBlockDevice(
        volumeSpecification.map(value => value.asEditable),
        device.map(value => value)
      )
    def volumeSpecification
        : Optional[zio.aws.emr.model.VolumeSpecification.ReadOnly]
    def device: Optional[String]
    def getVolumeSpecification
        : ZIO[Any, AwsError, zio.aws.emr.model.VolumeSpecification.ReadOnly] =
      AwsError.unwrapOptionField("volumeSpecification", volumeSpecification)
    def getDevice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("device", device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.EbsBlockDevice
  ) extends zio.aws.emr.model.EbsBlockDevice.ReadOnly {
    override val volumeSpecification
        : Optional[zio.aws.emr.model.VolumeSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeSpecification())
        .map(value => zio.aws.emr.model.VolumeSpecification.wrap(value))
    override val device: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.device())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.EbsBlockDevice
  ): zio.aws.emr.model.EbsBlockDevice.ReadOnly = new Wrapper(impl)
}
