package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInstanceFleetsResponse(
    instanceFleets: Optional[Iterable[zio.aws.emr.model.InstanceFleet]] =
      Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse = {
    import ListInstanceFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse
      .builder()
      .optionallyWith(
        instanceFleets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceFleets)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListInstanceFleetsResponse.ReadOnly =
    zio.aws.emr.model.ListInstanceFleetsResponse.wrap(buildAwsValue())
}
object ListInstanceFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListInstanceFleetsResponse =
      zio.aws.emr.model.ListInstanceFleetsResponse(
        instanceFleets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def instanceFleets: Optional[List[zio.aws.emr.model.InstanceFleet.ReadOnly]]
    def marker: Optional[Marker]
    def getInstanceFleets
        : ZIO[Any, AwsError, List[zio.aws.emr.model.InstanceFleet.ReadOnly]] =
      AwsError.unwrapOptionField("instanceFleets", instanceFleets)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse
  ) extends zio.aws.emr.model.ListInstanceFleetsResponse.ReadOnly {
    override val instanceFleets
        : Optional[List[zio.aws.emr.model.InstanceFleet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceFleets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceFleet.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse
  ): zio.aws.emr.model.ListInstanceFleetsResponse.ReadOnly = new Wrapper(impl)
}
