package zio.aws.emr.model
import zio.aws.emr.model.primitives.{StepId, ClusterId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStepRequest(clusterId: ClusterId, stepId: StepId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.DescribeStepRequest = {
    import DescribeStepRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.DescribeStepRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .stepId(StepId.unwrap(stepId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.DescribeStepRequest.ReadOnly =
    zio.aws.emr.model.DescribeStepRequest.wrap(buildAwsValue())
}
object DescribeStepRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.DescribeStepRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.DescribeStepRequest =
      zio.aws.emr.model.DescribeStepRequest(clusterId, stepId)
    def clusterId: ClusterId
    def stepId: StepId
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getStepId: ZIO[Any, Nothing, StepId] = ZIO.succeed(stepId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.DescribeStepRequest
  ) extends zio.aws.emr.model.DescribeStepRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val stepId: StepId =
      zio.aws.emr.model.primitives.StepId(impl.stepId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.DescribeStepRequest
  ): zio.aws.emr.model.DescribeStepRequest.ReadOnly = new Wrapper(impl)
}
