package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListNotebookExecutionsResponse(
    notebookExecutions: Optional[
      Iterable[zio.aws.emr.model.NotebookExecutionSummary]
    ] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse = {
    import ListNotebookExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse
      .builder()
      .optionallyWith(
        notebookExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.notebookExecutions)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListNotebookExecutionsResponse.ReadOnly =
    zio.aws.emr.model.ListNotebookExecutionsResponse.wrap(buildAwsValue())
}
object ListNotebookExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListNotebookExecutionsResponse =
      zio.aws.emr.model.ListNotebookExecutionsResponse(
        notebookExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def notebookExecutions
        : Optional[List[zio.aws.emr.model.NotebookExecutionSummary.ReadOnly]]
    def marker: Optional[Marker]
    def getNotebookExecutions: ZIO[Any, AwsError, List[
      zio.aws.emr.model.NotebookExecutionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("notebookExecutions", notebookExecutions)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse
  ) extends zio.aws.emr.model.ListNotebookExecutionsResponse.ReadOnly {
    override val notebookExecutions
        : Optional[List[zio.aws.emr.model.NotebookExecutionSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notebookExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.NotebookExecutionSummary.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListNotebookExecutionsResponse
  ): zio.aws.emr.model.ListNotebookExecutionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
