package zio.aws.emr.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.emr.model.primitives.{
  XmlString,
  Marker,
  Date,
  XmlStringMaxLen256
}
import scala.jdk.CollectionConverters._
final case class ListNotebookExecutionsRequest(
    editorId: Optional[XmlStringMaxLen256] = Optional.Absent,
    status: Optional[zio.aws.emr.model.NotebookExecutionStatus] =
      Optional.Absent,
    from: Optional[Date] = Optional.Absent,
    to: Optional[Date] = Optional.Absent,
    marker: Optional[Marker] = Optional.Absent,
    executionEngineId: Optional[XmlString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest = {
    import ListNotebookExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest
      .builder()
      .optionallyWith(
        editorId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.editorId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(from.map(value => Date.unwrap(value): Instant))(_.from)
      .optionallyWith(to.map(value => Date.unwrap(value): Instant))(_.to)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        executionEngineId.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.executionEngineId)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListNotebookExecutionsRequest.ReadOnly =
    zio.aws.emr.model.ListNotebookExecutionsRequest.wrap(buildAwsValue())
}
object ListNotebookExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListNotebookExecutionsRequest =
      zio.aws.emr.model.ListNotebookExecutionsRequest(
        editorId.map(value => value),
        status.map(value => value),
        from.map(value => value),
        to.map(value => value),
        marker.map(value => value),
        executionEngineId.map(value => value)
      )
    def editorId: Optional[XmlStringMaxLen256]
    def status: Optional[zio.aws.emr.model.NotebookExecutionStatus]
    def from: Optional[Date]
    def to: Optional[Date]
    def marker: Optional[Marker]
    def executionEngineId: Optional[XmlString]
    def getEditorId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("editorId", editorId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.NotebookExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFrom: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, Date] = AwsError.unwrapOptionField("to", to)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getExecutionEngineId: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("executionEngineId", executionEngineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest
  ) extends zio.aws.emr.model.ListNotebookExecutionsRequest.ReadOnly {
    override val editorId: Optional[XmlStringMaxLen256] = zio.aws.core.internal
      .optionalFromNullable(impl.editorId())
      .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val status: Optional[zio.aws.emr.model.NotebookExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.NotebookExecutionStatus.wrap(value))
    override val from: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.from())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val to: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.to())
      .map(value => zio.aws.emr.model.primitives.Date(value))
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
    override val executionEngineId: Optional[XmlString] = zio.aws.core.internal
      .optionalFromNullable(impl.executionEngineId())
      .map(value => zio.aws.emr.model.primitives.XmlString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListNotebookExecutionsRequest
  ): zio.aws.emr.model.ListNotebookExecutionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
