package zio.aws.emr.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSupportedInstanceTypesResponse(
    supportedInstanceTypes: Optional[
      Iterable[zio.aws.emr.model.SupportedInstanceType]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesResponse = {
    import ListSupportedInstanceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesResponse
      .builder()
      .optionallyWith(
        supportedInstanceTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedInstanceTypes)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.emr.model.ListSupportedInstanceTypesResponse.ReadOnly =
    zio.aws.emr.model.ListSupportedInstanceTypesResponse.wrap(buildAwsValue())
}
object ListSupportedInstanceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListSupportedInstanceTypesResponse =
      zio.aws.emr.model.ListSupportedInstanceTypesResponse(
        supportedInstanceTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def supportedInstanceTypes
        : Optional[List[zio.aws.emr.model.SupportedInstanceType.ReadOnly]]
    def marker: Optional[String]
    def getSupportedInstanceTypes: ZIO[Any, AwsError, List[
      zio.aws.emr.model.SupportedInstanceType.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "supportedInstanceTypes",
      supportedInstanceTypes
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesResponse
  ) extends zio.aws.emr.model.ListSupportedInstanceTypesResponse.ReadOnly {
    override val supportedInstanceTypes
        : Optional[List[zio.aws.emr.model.SupportedInstanceType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.SupportedInstanceType.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesResponse
  ): zio.aws.emr.model.ListSupportedInstanceTypesResponse.ReadOnly =
    new Wrapper(impl)
}
