package zio.aws.emr.model
import zio.aws.emr.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStudiosResponse(
    studios: Optional[Iterable[zio.aws.emr.model.StudioSummary]] =
      Optional.Absent,
    marker: Optional[Marker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ListStudiosResponse = {
    import ListStudiosResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ListStudiosResponse
      .builder()
      .optionallyWith(
        studios.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.studios)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ListStudiosResponse.ReadOnly =
    zio.aws.emr.model.ListStudiosResponse.wrap(buildAwsValue())
}
object ListStudiosResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ListStudiosResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ListStudiosResponse =
      zio.aws.emr.model.ListStudiosResponse(
        studios.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def studios: Optional[List[zio.aws.emr.model.StudioSummary.ReadOnly]]
    def marker: Optional[Marker]
    def getStudios
        : ZIO[Any, AwsError, List[zio.aws.emr.model.StudioSummary.ReadOnly]] =
      AwsError.unwrapOptionField("studios", studios)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ListStudiosResponse
  ) extends zio.aws.emr.model.ListStudiosResponse.ReadOnly {
    override val studios
        : Optional[List[zio.aws.emr.model.StudioSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.studios())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.StudioSummary.wrap(item)
          }.toList
        )
    override val marker: Optional[Marker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.emr.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ListStudiosResponse
  ): zio.aws.emr.model.ListStudiosResponse.ReadOnly = new Wrapper(impl)
}
