package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait InstanceFleetState {
  def unwrap: software.amazon.awssdk.services.emr.model.InstanceFleetState
}
object InstanceFleetState {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.InstanceFleetState
  ): zio.aws.emr.model.InstanceFleetState = value match {
    case software.amazon.awssdk.services.emr.model.InstanceFleetState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetState.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetState.BOOTSTRAPPING =>
      val r = BOOTSTRAPPING
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetState.RESIZING =>
      val r = RESIZING
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetState.SUSPENDED =>
      val r = SUSPENDED
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetState.TERMINATING =>
      val r = TERMINATING
      r
    case software.amazon.awssdk.services.emr.model.InstanceFleetState.TERMINATED =>
      val r = TERMINATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.InstanceFleetState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetState =
      software.amazon.awssdk.services.emr.model.InstanceFleetState.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONING extends zio.aws.emr.model.InstanceFleetState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetState =
      software.amazon.awssdk.services.emr.model.InstanceFleetState.PROVISIONING
  }
  case object BOOTSTRAPPING extends zio.aws.emr.model.InstanceFleetState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetState =
      software.amazon.awssdk.services.emr.model.InstanceFleetState.BOOTSTRAPPING
  }
  case object RUNNING extends zio.aws.emr.model.InstanceFleetState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetState =
      software.amazon.awssdk.services.emr.model.InstanceFleetState.RUNNING
  }
  case object RESIZING extends zio.aws.emr.model.InstanceFleetState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetState =
      software.amazon.awssdk.services.emr.model.InstanceFleetState.RESIZING
  }
  case object SUSPENDED extends zio.aws.emr.model.InstanceFleetState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetState =
      software.amazon.awssdk.services.emr.model.InstanceFleetState.SUSPENDED
  }
  case object TERMINATING extends zio.aws.emr.model.InstanceFleetState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetState =
      software.amazon.awssdk.services.emr.model.InstanceFleetState.TERMINATING
  }
  case object TERMINATED extends zio.aws.emr.model.InstanceFleetState {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.InstanceFleetState =
      software.amazon.awssdk.services.emr.model.InstanceFleetState.TERMINATED
  }
}
