package zio.aws.emr.model
import zio.aws.emr.model.primitives.{IAMRoleArn, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecutionEngineConfig(
    id: XmlStringMaxLen256,
    `type`: Optional[zio.aws.emr.model.ExecutionEngineType] = Optional.Absent,
    masterInstanceSecurityGroupId: Optional[XmlStringMaxLen256] =
      Optional.Absent,
    executionRoleArn: Optional[IAMRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.ExecutionEngineConfig = {
    import ExecutionEngineConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.ExecutionEngineConfig
      .builder()
      .id(XmlStringMaxLen256.unwrap(id): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        masterInstanceSecurityGroupId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.masterInstanceSecurityGroupId)
      .optionallyWith(
        executionRoleArn.map(value =>
          IAMRoleArn.unwrap(value): java.lang.String
        )
      )(_.executionRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.ExecutionEngineConfig.ReadOnly =
    zio.aws.emr.model.ExecutionEngineConfig.wrap(buildAwsValue())
}
object ExecutionEngineConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.ExecutionEngineConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.ExecutionEngineConfig =
      zio.aws.emr.model.ExecutionEngineConfig(
        id,
        `type`.map(value => value),
        masterInstanceSecurityGroupId.map(value => value),
        executionRoleArn.map(value => value)
      )
    def id: XmlStringMaxLen256
    def `type`: Optional[zio.aws.emr.model.ExecutionEngineType]
    def masterInstanceSecurityGroupId: Optional[XmlStringMaxLen256]
    def executionRoleArn: Optional[IAMRoleArn]
    def getId: ZIO[Any, Nothing, XmlStringMaxLen256] = ZIO.succeed(id)
    def getType: ZIO[Any, AwsError, zio.aws.emr.model.ExecutionEngineType] =
      AwsError.unwrapOptionField("type", `type`)
    def getMasterInstanceSecurityGroupId
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "masterInstanceSecurityGroupId",
      masterInstanceSecurityGroupId
    )
    def getExecutionRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.ExecutionEngineConfig
  ) extends zio.aws.emr.model.ExecutionEngineConfig.ReadOnly {
    override val id: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.id())
    override val `type`: Optional[zio.aws.emr.model.ExecutionEngineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.emr.model.ExecutionEngineType.wrap(value))
    override val masterInstanceSecurityGroupId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterInstanceSecurityGroupId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val executionRoleArn: Optional[IAMRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => zio.aws.emr.model.primitives.IAMRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.ExecutionEngineConfig
  ): zio.aws.emr.model.ExecutionEngineConfig.ReadOnly = new Wrapper(impl)
}
