package zio.aws.emr.model
import zio.aws.emr.model.primitives.{InstanceGroupId, ClusterId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutAutoScalingPolicyRequest(
    clusterId: ClusterId,
    instanceGroupId: InstanceGroupId,
    autoScalingPolicy: zio.aws.emr.model.AutoScalingPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyRequest = {
    import PutAutoScalingPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyRequest
      .builder()
      .clusterId(ClusterId.unwrap(clusterId): java.lang.String)
      .instanceGroupId(
        InstanceGroupId.unwrap(instanceGroupId): java.lang.String
      )
      .autoScalingPolicy(autoScalingPolicy.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.emr.model.PutAutoScalingPolicyRequest.ReadOnly =
    zio.aws.emr.model.PutAutoScalingPolicyRequest.wrap(buildAwsValue())
}
object PutAutoScalingPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.PutAutoScalingPolicyRequest =
      zio.aws.emr.model.PutAutoScalingPolicyRequest(
        clusterId,
        instanceGroupId,
        autoScalingPolicy.asEditable
      )
    def clusterId: ClusterId
    def instanceGroupId: InstanceGroupId
    def autoScalingPolicy: zio.aws.emr.model.AutoScalingPolicy.ReadOnly
    def getClusterId: ZIO[Any, Nothing, ClusterId] = ZIO.succeed(clusterId)
    def getInstanceGroupId: ZIO[Any, Nothing, InstanceGroupId] =
      ZIO.succeed(instanceGroupId)
    def getAutoScalingPolicy
        : ZIO[Any, Nothing, zio.aws.emr.model.AutoScalingPolicy.ReadOnly] =
      ZIO.succeed(autoScalingPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyRequest
  ) extends zio.aws.emr.model.PutAutoScalingPolicyRequest.ReadOnly {
    override val clusterId: ClusterId =
      zio.aws.emr.model.primitives.ClusterId(impl.clusterId())
    override val instanceGroupId: InstanceGroupId =
      zio.aws.emr.model.primitives.InstanceGroupId(impl.instanceGroupId())
    override val autoScalingPolicy
        : zio.aws.emr.model.AutoScalingPolicy.ReadOnly =
      zio.aws.emr.model.AutoScalingPolicy.wrap(impl.autoScalingPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.PutAutoScalingPolicyRequest
  ): zio.aws.emr.model.PutAutoScalingPolicyRequest.ReadOnly = new Wrapper(impl)
}
