package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait OutputNotebookFormat {
  def unwrap: software.amazon.awssdk.services.emr.model.OutputNotebookFormat
}
object OutputNotebookFormat {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.OutputNotebookFormat
  ): zio.aws.emr.model.OutputNotebookFormat = value match {
    case software.amazon.awssdk.services.emr.model.OutputNotebookFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.OutputNotebookFormat.HTML =>
      val r = HTML
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.emr.model.OutputNotebookFormat {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.OutputNotebookFormat =
      software.amazon.awssdk.services.emr.model.OutputNotebookFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object HTML extends zio.aws.emr.model.OutputNotebookFormat {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.OutputNotebookFormat =
      software.amazon.awssdk.services.emr.model.OutputNotebookFormat.HTML
  }
}
