package zio.aws.emr.model
import zio.aws.emr.model.primitives.{XmlStringMaxLen256, Integer, InstanceType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobFlowInstancesConfig(
    masterInstanceType: Optional[InstanceType] = Optional.Absent,
    slaveInstanceType: Optional[InstanceType] = Optional.Absent,
    instanceCount: Optional[Integer] = Optional.Absent,
    instanceGroups: Optional[Iterable[zio.aws.emr.model.InstanceGroupConfig]] =
      Optional.Absent,
    instanceFleets: Optional[Iterable[zio.aws.emr.model.InstanceFleetConfig]] =
      Optional.Absent,
    ec2KeyName: Optional[XmlStringMaxLen256] = Optional.Absent,
    placement: Optional[zio.aws.emr.model.PlacementType] = Optional.Absent,
    keepJobFlowAliveWhenNoSteps: Optional[Boolean] = Optional.Absent,
    terminationProtected: Optional[Boolean] = Optional.Absent,
    hadoopVersion: Optional[XmlStringMaxLen256] = Optional.Absent,
    ec2SubnetId: Optional[XmlStringMaxLen256] = Optional.Absent,
    ec2SubnetIds: Optional[Iterable[XmlStringMaxLen256]] = Optional.Absent,
    emrManagedMasterSecurityGroup: Optional[XmlStringMaxLen256] =
      Optional.Absent,
    emrManagedSlaveSecurityGroup: Optional[XmlStringMaxLen256] =
      Optional.Absent,
    serviceAccessSecurityGroup: Optional[XmlStringMaxLen256] = Optional.Absent,
    additionalMasterSecurityGroups: Optional[Iterable[XmlStringMaxLen256]] =
      Optional.Absent,
    additionalSlaveSecurityGroups: Optional[Iterable[XmlStringMaxLen256]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig = {
    import JobFlowInstancesConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig
      .builder()
      .optionallyWith(
        masterInstanceType.map(value =>
          InstanceType.unwrap(value): java.lang.String
        )
      )(_.masterInstanceType)
      .optionallyWith(
        slaveInstanceType.map(value =>
          InstanceType.unwrap(value): java.lang.String
        )
      )(_.slaveInstanceType)
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(
        instanceGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceGroups)
      .optionallyWith(
        instanceFleets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceFleets)
      .optionallyWith(
        ec2KeyName.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.ec2KeyName)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        keepJobFlowAliveWhenNoSteps.map(value => value: java.lang.Boolean)
      )(_.keepJobFlowAliveWhenNoSteps)
      .optionallyWith(
        terminationProtected.map(value => value: java.lang.Boolean)
      )(_.terminationProtected)
      .optionallyWith(
        hadoopVersion.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.hadoopVersion)
      .optionallyWith(
        ec2SubnetId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.ec2SubnetId)
      .optionallyWith(
        ec2SubnetIds.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SubnetIds)
      .optionallyWith(
        emrManagedMasterSecurityGroup.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.emrManagedMasterSecurityGroup)
      .optionallyWith(
        emrManagedSlaveSecurityGroup.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.emrManagedSlaveSecurityGroup)
      .optionallyWith(
        serviceAccessSecurityGroup.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.serviceAccessSecurityGroup)
      .optionallyWith(
        additionalMasterSecurityGroups.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalMasterSecurityGroups)
      .optionallyWith(
        additionalSlaveSecurityGroups.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalSlaveSecurityGroups)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly =
    zio.aws.emr.model.JobFlowInstancesConfig.wrap(buildAwsValue())
}
object JobFlowInstancesConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.JobFlowInstancesConfig =
      zio.aws.emr.model.JobFlowInstancesConfig(
        masterInstanceType.map(value => value),
        slaveInstanceType.map(value => value),
        instanceCount.map(value => value),
        instanceGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceFleets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ec2KeyName.map(value => value),
        placement.map(value => value.asEditable),
        keepJobFlowAliveWhenNoSteps.map(value => value),
        terminationProtected.map(value => value),
        hadoopVersion.map(value => value),
        ec2SubnetId.map(value => value),
        ec2SubnetIds.map(value => value),
        emrManagedMasterSecurityGroup.map(value => value),
        emrManagedSlaveSecurityGroup.map(value => value),
        serviceAccessSecurityGroup.map(value => value),
        additionalMasterSecurityGroups.map(value => value),
        additionalSlaveSecurityGroups.map(value => value)
      )
    def masterInstanceType: Optional[InstanceType]
    def slaveInstanceType: Optional[InstanceType]
    def instanceCount: Optional[Integer]
    def instanceGroups
        : Optional[List[zio.aws.emr.model.InstanceGroupConfig.ReadOnly]]
    def instanceFleets
        : Optional[List[zio.aws.emr.model.InstanceFleetConfig.ReadOnly]]
    def ec2KeyName: Optional[XmlStringMaxLen256]
    def placement: Optional[zio.aws.emr.model.PlacementType.ReadOnly]
    def keepJobFlowAliveWhenNoSteps: Optional[Boolean]
    def terminationProtected: Optional[Boolean]
    def hadoopVersion: Optional[XmlStringMaxLen256]
    def ec2SubnetId: Optional[XmlStringMaxLen256]
    def ec2SubnetIds: Optional[List[XmlStringMaxLen256]]
    def emrManagedMasterSecurityGroup: Optional[XmlStringMaxLen256]
    def emrManagedSlaveSecurityGroup: Optional[XmlStringMaxLen256]
    def serviceAccessSecurityGroup: Optional[XmlStringMaxLen256]
    def additionalMasterSecurityGroups: Optional[List[XmlStringMaxLen256]]
    def additionalSlaveSecurityGroups: Optional[List[XmlStringMaxLen256]]
    def getMasterInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("masterInstanceType", masterInstanceType)
    def getSlaveInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("slaveInstanceType", slaveInstanceType)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getInstanceGroups: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceGroupConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceGroups", instanceGroups)
    def getInstanceFleets: ZIO[Any, AwsError, List[
      zio.aws.emr.model.InstanceFleetConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceFleets", instanceFleets)
    def getEc2KeyName: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("ec2KeyName", ec2KeyName)
    def getPlacement
        : ZIO[Any, AwsError, zio.aws.emr.model.PlacementType.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getKeepJobFlowAliveWhenNoSteps: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "keepJobFlowAliveWhenNoSteps",
        keepJobFlowAliveWhenNoSteps
      )
    def getTerminationProtected: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("terminationProtected", terminationProtected)
    def getHadoopVersion: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("hadoopVersion", hadoopVersion)
    def getEc2SubnetId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("ec2SubnetId", ec2SubnetId)
    def getEc2SubnetIds: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("ec2SubnetIds", ec2SubnetIds)
    def getEmrManagedMasterSecurityGroup
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "emrManagedMasterSecurityGroup",
      emrManagedMasterSecurityGroup
    )
    def getEmrManagedSlaveSecurityGroup
        : ZIO[Any, AwsError, XmlStringMaxLen256] = AwsError.unwrapOptionField(
      "emrManagedSlaveSecurityGroup",
      emrManagedSlaveSecurityGroup
    )
    def getServiceAccessSecurityGroup: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField(
        "serviceAccessSecurityGroup",
        serviceAccessSecurityGroup
      )
    def getAdditionalMasterSecurityGroups
        : ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField(
        "additionalMasterSecurityGroups",
        additionalMasterSecurityGroups
      )
    def getAdditionalSlaveSecurityGroups
        : ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField(
        "additionalSlaveSecurityGroups",
        additionalSlaveSecurityGroups
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig
  ) extends zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly {
    override val masterInstanceType: Optional[InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.masterInstanceType())
        .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val slaveInstanceType: Optional[InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slaveInstanceType())
        .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val instanceGroups
        : Optional[List[zio.aws.emr.model.InstanceGroupConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceGroupConfig.wrap(item)
          }.toList
        )
    override val instanceFleets
        : Optional[List[zio.aws.emr.model.InstanceFleetConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceFleets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.InstanceFleetConfig.wrap(item)
          }.toList
        )
    override val ec2KeyName: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2KeyName())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val placement: Optional[zio.aws.emr.model.PlacementType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.emr.model.PlacementType.wrap(value))
    override val keepJobFlowAliveWhenNoSteps: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keepJobFlowAliveWhenNoSteps())
        .map(value => value: Boolean)
    override val terminationProtected: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.terminationProtected())
      .map(value => value: Boolean)
    override val hadoopVersion: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hadoopVersion())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val ec2SubnetId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SubnetId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val ec2SubnetIds: Optional[List[XmlStringMaxLen256]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2SubnetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
          }.toList
        )
    override val emrManagedMasterSecurityGroup: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emrManagedMasterSecurityGroup())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val emrManagedSlaveSecurityGroup: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emrManagedSlaveSecurityGroup())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val serviceAccessSecurityGroup: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceAccessSecurityGroup())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
    override val additionalMasterSecurityGroups
        : Optional[List[XmlStringMaxLen256]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalMasterSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
    override val additionalSlaveSecurityGroups
        : Optional[List[XmlStringMaxLen256]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalSlaveSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.emr.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig
  ): zio.aws.emr.model.JobFlowInstancesConfig.ReadOnly = new Wrapper(impl)
}
