package zio.aws.emr.model
import zio.aws.emr.model.primitives.{
  XmlStringMaxLen256,
  InstanceGroupId,
  BooleanObject,
  InstanceType,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceGroup(
    id: Optional[InstanceGroupId] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    market: Optional[zio.aws.emr.model.MarketType] = Optional.Absent,
    instanceGroupType: Optional[zio.aws.emr.model.InstanceGroupType] =
      Optional.Absent,
    bidPrice: Optional[String] = Optional.Absent,
    instanceType: Optional[InstanceType] = Optional.Absent,
    requestedInstanceCount: Optional[Integer] = Optional.Absent,
    runningInstanceCount: Optional[Integer] = Optional.Absent,
    status: Optional[zio.aws.emr.model.InstanceGroupStatus] = Optional.Absent,
    configurations: Optional[Iterable[zio.aws.emr.model.Configuration]] =
      Optional.Absent,
    configurationsVersion: Optional[Long] = Optional.Absent,
    lastSuccessfullyAppliedConfigurations: Optional[
      Iterable[zio.aws.emr.model.Configuration]
    ] = Optional.Absent,
    lastSuccessfullyAppliedConfigurationsVersion: Optional[Long] =
      Optional.Absent,
    ebsBlockDevices: Optional[Iterable[zio.aws.emr.model.EbsBlockDevice]] =
      Optional.Absent,
    ebsOptimized: Optional[BooleanObject] = Optional.Absent,
    shrinkPolicy: Optional[zio.aws.emr.model.ShrinkPolicy] = Optional.Absent,
    autoScalingPolicy: Optional[
      zio.aws.emr.model.AutoScalingPolicyDescription
    ] = Optional.Absent,
    customAmiId: Optional[XmlStringMaxLen256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceGroup = {
    import InstanceGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceGroup
      .builder()
      .optionallyWith(
        id.map(value => InstanceGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(market.map(value => value.unwrap))(_.market)
      .optionallyWith(instanceGroupType.map(value => value.unwrap))(
        _.instanceGroupType
      )
      .optionallyWith(bidPrice.map(value => value: java.lang.String))(
        _.bidPrice
      )
      .optionallyWith(
        instanceType.map(value => InstanceType.unwrap(value): java.lang.String)
      )(_.instanceType)
      .optionallyWith(
        requestedInstanceCount.map(value => value: java.lang.Integer)
      )(_.requestedInstanceCount)
      .optionallyWith(
        runningInstanceCount.map(value => value: java.lang.Integer)
      )(_.runningInstanceCount)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(
        configurationsVersion.map(value => value: java.lang.Long)
      )(_.configurationsVersion)
      .optionallyWith(
        lastSuccessfullyAppliedConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lastSuccessfullyAppliedConfigurations)
      .optionallyWith(
        lastSuccessfullyAppliedConfigurationsVersion.map(value =>
          value: java.lang.Long
        )
      )(_.lastSuccessfullyAppliedConfigurationsVersion)
      .optionallyWith(
        ebsBlockDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ebsBlockDevices)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(shrinkPolicy.map(value => value.buildAwsValue()))(
        _.shrinkPolicy
      )
      .optionallyWith(autoScalingPolicy.map(value => value.buildAwsValue()))(
        _.autoScalingPolicy
      )
      .optionallyWith(
        customAmiId.map(value =>
          XmlStringMaxLen256.unwrap(value): java.lang.String
        )
      )(_.customAmiId)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceGroup.ReadOnly =
    zio.aws.emr.model.InstanceGroup.wrap(buildAwsValue())
}
object InstanceGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.emr.model.InstanceGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceGroup =
      zio.aws.emr.model.InstanceGroup(
        id.map(value => value),
        name.map(value => value),
        market.map(value => value),
        instanceGroupType.map(value => value),
        bidPrice.map(value => value),
        instanceType.map(value => value),
        requestedInstanceCount.map(value => value),
        runningInstanceCount.map(value => value),
        status.map(value => value.asEditable),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationsVersion.map(value => value),
        lastSuccessfullyAppliedConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastSuccessfullyAppliedConfigurationsVersion.map(value => value),
        ebsBlockDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        shrinkPolicy.map(value => value.asEditable),
        autoScalingPolicy.map(value => value.asEditable),
        customAmiId.map(value => value)
      )
    def id: Optional[InstanceGroupId]
    def name: Optional[String]
    def market: Optional[zio.aws.emr.model.MarketType]
    def instanceGroupType: Optional[zio.aws.emr.model.InstanceGroupType]
    def bidPrice: Optional[String]
    def instanceType: Optional[InstanceType]
    def requestedInstanceCount: Optional[Integer]
    def runningInstanceCount: Optional[Integer]
    def status: Optional[zio.aws.emr.model.InstanceGroupStatus.ReadOnly]
    def configurations: Optional[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def configurationsVersion: Optional[Long]
    def lastSuccessfullyAppliedConfigurations
        : Optional[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def lastSuccessfullyAppliedConfigurationsVersion: Optional[Long]
    def ebsBlockDevices
        : Optional[List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]]
    def ebsOptimized: Optional[BooleanObject]
    def shrinkPolicy: Optional[zio.aws.emr.model.ShrinkPolicy.ReadOnly]
    def autoScalingPolicy
        : Optional[zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly]
    def customAmiId: Optional[XmlStringMaxLen256]
    def getId: ZIO[Any, AwsError, InstanceGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getMarket: ZIO[Any, AwsError, zio.aws.emr.model.MarketType] =
      AwsError.unwrapOptionField("market", market)
    def getInstanceGroupType
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceGroupType] =
      AwsError.unwrapOptionField("instanceGroupType", instanceGroupType)
    def getBidPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bidPrice", bidPrice)
    def getInstanceType: ZIO[Any, AwsError, InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getRequestedInstanceCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("requestedInstanceCount", requestedInstanceCount)
    def getRunningInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningInstanceCount", runningInstanceCount)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.emr.model.InstanceGroupStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getConfigurationsVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("configurationsVersion", configurationsVersion)
    def getLastSuccessfullyAppliedConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField(
        "lastSuccessfullyAppliedConfigurations",
        lastSuccessfullyAppliedConfigurations
      )
    def getLastSuccessfullyAppliedConfigurationsVersion
        : ZIO[Any, AwsError, Long] = AwsError.unwrapOptionField(
      "lastSuccessfullyAppliedConfigurationsVersion",
      lastSuccessfullyAppliedConfigurationsVersion
    )
    def getEbsBlockDevices
        : ZIO[Any, AwsError, List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]] =
      AwsError.unwrapOptionField("ebsBlockDevices", ebsBlockDevices)
    def getEbsOptimized: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getShrinkPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.ShrinkPolicy.ReadOnly] =
      AwsError.unwrapOptionField("shrinkPolicy", shrinkPolicy)
    def getAutoScalingPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly
    ] = AwsError.unwrapOptionField("autoScalingPolicy", autoScalingPolicy)
    def getCustomAmiId: ZIO[Any, AwsError, XmlStringMaxLen256] =
      AwsError.unwrapOptionField("customAmiId", customAmiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroup
  ) extends zio.aws.emr.model.InstanceGroup.ReadOnly {
    override val id: Optional[InstanceGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.emr.model.primitives.InstanceGroupId(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val market: Optional[zio.aws.emr.model.MarketType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.market())
        .map(value => zio.aws.emr.model.MarketType.wrap(value))
    override val instanceGroupType
        : Optional[zio.aws.emr.model.InstanceGroupType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceGroupType())
      .map(value => zio.aws.emr.model.InstanceGroupType.wrap(value))
    override val bidPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bidPrice())
      .map(value => value: String)
    override val instanceType: Optional[InstanceType] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => zio.aws.emr.model.primitives.InstanceType(value))
    override val requestedInstanceCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestedInstanceCount())
        .map(value => value: Integer)
    override val runningInstanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.runningInstanceCount())
      .map(value => value: Integer)
    override val status
        : Optional[zio.aws.emr.model.InstanceGroupStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.emr.model.InstanceGroupStatus.wrap(value))
    override val configurations
        : Optional[List[zio.aws.emr.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Configuration.wrap(item)
          }.toList
        )
    override val configurationsVersion: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationsVersion())
      .map(value => value: Long)
    override val lastSuccessfullyAppliedConfigurations
        : Optional[List[zio.aws.emr.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfullyAppliedConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Configuration.wrap(item)
          }.toList
        )
    override val lastSuccessfullyAppliedConfigurationsVersion
        : Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastSuccessfullyAppliedConfigurationsVersion())
      .map(value => value: Long)
    override val ebsBlockDevices
        : Optional[List[zio.aws.emr.model.EbsBlockDevice.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsBlockDevices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.EbsBlockDevice.wrap(item)
          }.toList
        )
    override val ebsOptimized: Optional[BooleanObject] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: BooleanObject)
    override val shrinkPolicy
        : Optional[zio.aws.emr.model.ShrinkPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shrinkPolicy())
        .map(value => zio.aws.emr.model.ShrinkPolicy.wrap(value))
    override val autoScalingPolicy
        : Optional[zio.aws.emr.model.AutoScalingPolicyDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingPolicy())
        .map(value =>
          zio.aws.emr.model.AutoScalingPolicyDescription.wrap(value)
        )
    override val customAmiId: Optional[XmlStringMaxLen256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAmiId())
        .map(value => zio.aws.emr.model.primitives.XmlStringMaxLen256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroup
  ): zio.aws.emr.model.InstanceGroup.ReadOnly = new Wrapper(impl)
}
