package zio.aws.emr.model
import zio.aws.emr.model.primitives.XmlStringMaxLen256
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddInstanceGroupsRequest(
    instanceGroups: Iterable[zio.aws.emr.model.InstanceGroupConfig],
    jobFlowId: XmlStringMaxLen256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.AddInstanceGroupsRequest = {
    import AddInstanceGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.AddInstanceGroupsRequest
      .builder()
      .instanceGroups(instanceGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .jobFlowId(XmlStringMaxLen256.unwrap(jobFlowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.AddInstanceGroupsRequest.ReadOnly =
    zio.aws.emr.model.AddInstanceGroupsRequest.wrap(buildAwsValue())
}
object AddInstanceGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.AddInstanceGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.AddInstanceGroupsRequest =
      zio.aws.emr.model.AddInstanceGroupsRequest(
        instanceGroups.map { item =>
          item.asEditable
        },
        jobFlowId
      )
    def instanceGroups: List[zio.aws.emr.model.InstanceGroupConfig.ReadOnly]
    def jobFlowId: XmlStringMaxLen256
    def getInstanceGroups: ZIO[Any, Nothing, List[
      zio.aws.emr.model.InstanceGroupConfig.ReadOnly
    ]] = ZIO.succeed(instanceGroups)
    def getJobFlowId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(jobFlowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceGroupsRequest
  ) extends zio.aws.emr.model.AddInstanceGroupsRequest.ReadOnly {
    override val instanceGroups
        : List[zio.aws.emr.model.InstanceGroupConfig.ReadOnly] = impl
      .instanceGroups()
      .asScala
      .map { item =>
        zio.aws.emr.model.InstanceGroupConfig.wrap(item)
      }
      .toList
    override val jobFlowId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.jobFlowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.AddInstanceGroupsRequest
  ): zio.aws.emr.model.AddInstanceGroupsRequest.ReadOnly = new Wrapper(impl)
}
