package zio.aws.emr.model
import scala.jdk.CollectionConverters._
sealed trait ScaleDownBehavior {
  def unwrap: software.amazon.awssdk.services.emr.model.ScaleDownBehavior
}
object ScaleDownBehavior {
  def wrap(
      value: software.amazon.awssdk.services.emr.model.ScaleDownBehavior
  ): zio.aws.emr.model.ScaleDownBehavior = value match {
    case software.amazon.awssdk.services.emr.model.ScaleDownBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.emr.model.ScaleDownBehavior.TERMINATE_AT_INSTANCE_HOUR =>
      val r = TERMINATE_AT_INSTANCE_HOUR
      r
    case software.amazon.awssdk.services.emr.model.ScaleDownBehavior.TERMINATE_AT_TASK_COMPLETION =>
      val r = TERMINATE_AT_TASK_COMPLETION
      r
  }
  case object unknownToSdkVersion extends zio.aws.emr.model.ScaleDownBehavior {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ScaleDownBehavior =
      software.amazon.awssdk.services.emr.model.ScaleDownBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object TERMINATE_AT_INSTANCE_HOUR
      extends zio.aws.emr.model.ScaleDownBehavior {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ScaleDownBehavior =
      software.amazon.awssdk.services.emr.model.ScaleDownBehavior.TERMINATE_AT_INSTANCE_HOUR
  }
  case object TERMINATE_AT_TASK_COMPLETION
      extends zio.aws.emr.model.ScaleDownBehavior {
    override def unwrap
        : software.amazon.awssdk.services.emr.model.ScaleDownBehavior =
      software.amazon.awssdk.services.emr.model.ScaleDownBehavior.TERMINATE_AT_TASK_COMPLETION
  }
}
