package zio.aws.emr.model
import zio.aws.emr.model.primitives.{InstanceId, Integer, XmlStringMaxLen256}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceGroupModifyConfig(
    instanceGroupId: XmlStringMaxLen256,
    instanceCount: Optional[Integer] = Optional.Absent,
    ec2InstanceIdsToTerminate: Optional[Iterable[InstanceId]] = Optional.Absent,
    shrinkPolicy: Optional[zio.aws.emr.model.ShrinkPolicy] = Optional.Absent,
    reconfigurationType: Optional[zio.aws.emr.model.ReconfigurationType] =
      Optional.Absent,
    configurations: Optional[Iterable[zio.aws.emr.model.Configuration]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig = {
    import InstanceGroupModifyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig
      .builder()
      .instanceGroupId(
        XmlStringMaxLen256.unwrap(instanceGroupId): java.lang.String
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(
        ec2InstanceIdsToTerminate.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2InstanceIdsToTerminate)
      .optionallyWith(shrinkPolicy.map(value => value.buildAwsValue()))(
        _.shrinkPolicy
      )
      .optionallyWith(reconfigurationType.map(value => value.unwrap))(
        _.reconfigurationType
      )
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .build()
  }
  def asReadOnly: zio.aws.emr.model.InstanceGroupModifyConfig.ReadOnly =
    zio.aws.emr.model.InstanceGroupModifyConfig.wrap(buildAwsValue())
}
object InstanceGroupModifyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.emr.model.InstanceGroupModifyConfig =
      zio.aws.emr.model.InstanceGroupModifyConfig(
        instanceGroupId,
        instanceCount.map(value => value),
        ec2InstanceIdsToTerminate.map(value => value),
        shrinkPolicy.map(value => value.asEditable),
        reconfigurationType.map(value => value),
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceGroupId: XmlStringMaxLen256
    def instanceCount: Optional[Integer]
    def ec2InstanceIdsToTerminate: Optional[List[InstanceId]]
    def shrinkPolicy: Optional[zio.aws.emr.model.ShrinkPolicy.ReadOnly]
    def reconfigurationType: Optional[zio.aws.emr.model.ReconfigurationType]
    def configurations: Optional[List[zio.aws.emr.model.Configuration.ReadOnly]]
    def getInstanceGroupId: ZIO[Any, Nothing, XmlStringMaxLen256] =
      ZIO.succeed(instanceGroupId)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getEc2InstanceIdsToTerminate: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField(
        "ec2InstanceIdsToTerminate",
        ec2InstanceIdsToTerminate
      )
    def getShrinkPolicy
        : ZIO[Any, AwsError, zio.aws.emr.model.ShrinkPolicy.ReadOnly] =
      AwsError.unwrapOptionField("shrinkPolicy", shrinkPolicy)
    def getReconfigurationType
        : ZIO[Any, AwsError, zio.aws.emr.model.ReconfigurationType] =
      AwsError.unwrapOptionField("reconfigurationType", reconfigurationType)
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.emr.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig
  ) extends zio.aws.emr.model.InstanceGroupModifyConfig.ReadOnly {
    override val instanceGroupId: XmlStringMaxLen256 =
      zio.aws.emr.model.primitives.XmlStringMaxLen256(impl.instanceGroupId())
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val ec2InstanceIdsToTerminate: Optional[List[InstanceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2InstanceIdsToTerminate())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.primitives.InstanceId(item)
          }.toList
        )
    override val shrinkPolicy
        : Optional[zio.aws.emr.model.ShrinkPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shrinkPolicy())
        .map(value => zio.aws.emr.model.ShrinkPolicy.wrap(value))
    override val reconfigurationType
        : Optional[zio.aws.emr.model.ReconfigurationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reconfigurationType())
        .map(value => zio.aws.emr.model.ReconfigurationType.wrap(value))
    override val configurations
        : Optional[List[zio.aws.emr.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.emr.model.Configuration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.emr.model.InstanceGroupModifyConfig
  ): zio.aws.emr.model.InstanceGroupModifyConfig.ReadOnly = new Wrapper(impl)
}
